#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

from blackduck.task.helper.risk_profile import *
from blackduck.hub_services_helper import HubServicesHelper
from blackduck.task import add_comment

if not blackduckServer:
    raise Exception("Blackduck server ID must be provided")

hub_services_helper = HubServicesHelper(params=blackduckServer)
hub_services_factory = hub_services_helper.get_hub_services_factory()
risk_profile_view, _, version_view = hub_services_helper.get_risk_profile(projectName, versionName)

HIGH = "HIGH"
MEDIUM = "MEDIUM"
LOW = "LOW"
OK = "OK"

vulnerability = risk_profile_view.categories.get("VULNERABILITY")
security_risk_profile = RiskProfile('Security Risk :',
                                    Risk(vulnerability.get(HIGH), securityRiskHighThreshold),
                                    Risk(vulnerability.get(MEDIUM), securityRiskMediumThreshold),
                                    Risk(vulnerability.get(LOW), securityRiskLowThreshold),
                                    Risk(vulnerability.get(OK), None))

license = risk_profile_view.categories.get("LICENSE")
license_risk_profile = RiskProfile('License Risk :',
                                   Risk(license.get(HIGH), licenseRiskHighThreshold),
                                   Risk(license.get(MEDIUM), licenseRiskMediumThreshold),
                                   Risk(license.get(LOW), licenseRiskLowThreshold),
                                   Risk(license.get(OK), None))

operational = risk_profile_view.categories.get("OPERATIONAL")
operational_risk_profile = RiskProfile('Operational Risk :',
                                       Risk(operational.get(HIGH), operationalRiskHighThreshold),
                                       Risk(operational.get(MEDIUM), operationalRiskMediumThreshold),
                                       Risk(operational.get(LOW), operationalRiskLowThreshold),
                                       Risk(operational.get(OK), None))

add_comment("Last Analysis Time: {}".format(risk_profile_view.bomLastUpdatedAt))

print "|   | High  | Medium   | Low   |  None  |"
print "|---|---|---|---|---|"
security_risk_profile.pretty_print()
license_risk_profile.pretty_print()
operational_risk_profile.pretty_print()

if not (security_risk_profile.validate() and license_risk_profile.validate() and operational_risk_profile.validate()):
    raise RuntimeError("Risks are not allowed")
