#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import re

from blackduck.hub_services_helper import HubServicesHelper
from com.synopsys.integration.blackduck.exception import DoesNotExistException
from java.lang import Exception


# Validate properties
missedProperties = []

if not blackduckServer:
    missedProperties.append('BlackDuck server')
if not timeFrame:
    missedProperties.append('Time frame')
if not projectName:
    missedProperties.append('Project name')
if not versionFilterRegex:
    missedProperties.append('Version regular expression')

if missedProperties:
    raise Exception("{} must be provided".format(', '.join(missedProperties)))

hub_services_helper = HubServicesHelper(params=blackduckServer)

end_date = timeFrame.getEndDate(dateTo)
start_date = timeFrame.getStartDate(dateFrom)

def filter_and_transform_releases(releases):
    filtered_data = []
    for releaseWrapper in releases:
        if (
            re.search(versionFilterRegex, releaseWrapper.release.version, flags=re.IGNORECASE) is not None
            and start_date <= releaseWrapper.release.createdOn.getTime() <= end_date
        ):
            filtered_data.append({
                'version': releaseWrapper.release.version,
                'createdOn': releaseWrapper.release.createdOn,
                'riskProfile': releaseWrapper.riskProfile.categories,
                'versionProjectUrl': hub_services_helper.get_project_version_url_by_id(releaseWrapper.release.id)
            })
    return filtered_data

try:
    project_view = hub_services_helper.get_project_view(projectName)
    all_releases = hub_services_helper.get_all_releases(project_view)

    data = {
        'releases': filter_and_transform_releases(all_releases),
        'projectUrl': hub_services_helper.get_project_url(project_view)
    }

except DoesNotExistException as exception:
    data = {'error': exception.message}
except Exception as exception:
    data = {'error': exception.getMessage()}

