/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.hub.bdio.model.externalid;

import com.synopsys.integration.hub.bdio.model.Forge;
import com.synopsys.integration.util.IntegrationEscapeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.RecursiveToStringStyle;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ExternalId {
    public static final String BDIO_ID_SEPARATOR = "/";
    public final Forge forge;
    public String group;
    public String name;
    public String version;
    public String architecture;
    public String[] moduleNames;
    public String path;
    private static final IntegrationEscapeUtil integrationEscapeUtil = new IntegrationEscapeUtil();

    public ExternalId(Forge forge) {
        this.forge = forge;
    }

    public String[] getExternalIdPieces() {
        if (StringUtils.isNotBlank((CharSequence)this.path)) {
            return new String[]{this.path};
        }
        if (this.moduleNames != null && this.moduleNames.length > 0) {
            return this.moduleNames;
        }
        if (StringUtils.isNotBlank((CharSequence)this.name) && StringUtils.isNotBlank((CharSequence)this.version)) {
            if (StringUtils.isNotBlank((CharSequence)this.group)) {
                return new String[]{this.group, this.name, this.version};
            }
            if (StringUtils.isNotBlank((CharSequence)this.architecture)) {
                return new String[]{this.name, this.version, this.architecture};
            }
            return new String[]{this.name, this.version};
        }
        ArrayList<String> bestGuessPieces = new ArrayList<String>();
        List<String> bestGuessCandidates = Arrays.asList(this.group, this.name, this.version, this.architecture);
        for (String candidate : bestGuessCandidates) {
            if (!StringUtils.isNotBlank((CharSequence)candidate)) continue;
            bestGuessPieces.add(candidate);
        }
        return bestGuessPieces.toArray(new String[bestGuessPieces.size()]);
    }

    public String createBdioId() {
        ArrayList<String> bdioIdPieces = new ArrayList<String>();
        bdioIdPieces.add(this.forge.toString());
        bdioIdPieces.addAll(integrationEscapeUtil.escapePiecesForUri(Arrays.asList(this.getExternalIdPieces())));
        return "http:" + StringUtils.join(bdioIdPieces, (String)BDIO_ID_SEPARATOR);
    }

    public String createExternalId() {
        return StringUtils.join((Object[])this.getExternalIdPieces(), (String)this.forge.getSeparator());
    }

    public String createHubOriginId() {
        return StringUtils.join((Object[])this.getExternalIdPieces(), (String)this.forge.getKbSeparator());
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)RecursiveToStringStyle.JSON_STYLE);
    }
}

