/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.hub.bdio.graph.summary;

import com.google.gson.Gson;
import com.synopsys.integration.hub.bdio.graph.DependencyGraph;
import com.synopsys.integration.hub.bdio.graph.summary.GraphSummary;
import com.synopsys.integration.hub.bdio.model.dependency.Dependency;
import com.synopsys.integration.hub.bdio.model.externalid.ExternalId;
import com.synopsys.integration.util.NameVersion;
import java.util.HashSet;
import java.util.LinkedList;

public class DependencyGraphSummarizer {
    private final Gson gson;

    public DependencyGraphSummarizer(Gson gson) {
        this.gson = gson;
    }

    public GraphSummary fromJson(String data) {
        return this.gson.fromJson(data, GraphSummary.class);
    }

    public String toJson(GraphSummary data) {
        return this.gson.toJson(data);
    }

    public String toJson(DependencyGraph graph) {
        return this.toJson(this.fromGraph(graph));
    }

    public GraphSummary fromGraph(DependencyGraph graph) {
        LinkedList<Dependency> unprocessed = new LinkedList<Dependency>(graph.getRootDependencies());
        HashSet<Dependency> processed = new HashSet<Dependency>();
        GraphSummary graphSummary = new GraphSummary();
        while (unprocessed.size() > 0) {
            Dependency nextDependency = (Dependency)unprocessed.remove();
            processed.add(nextDependency);
            String nextId = nextDependency.externalId.createBdioId();
            if (!graphSummary.dependencySummaries.containsKey(nextId)) {
                NameVersion nameVersion = new NameVersion();
                nameVersion.setName(nextDependency.name);
                nameVersion.setVersion(nextDependency.version);
                graphSummary.dependencySummaries.put(nextId, nameVersion);
            }
            for (Dependency dep : graph.getChildrenForParent(nextDependency)) {
                if (!graphSummary.externalDataIdRelationships.containsKey(nextId)) {
                    graphSummary.externalDataIdRelationships.put(nextId, new HashSet());
                }
                graphSummary.externalDataIdRelationships.get(nextId).add(dep.externalId.createBdioId());
                if (processed.contains(dep)) continue;
                unprocessed.add(dep);
            }
        }
        for (ExternalId externalId : graph.getRootDependencyExternalIds()) {
            graphSummary.rootExternalDataIds.add(externalId.createBdioId());
        }
        return graphSummary;
    }
}

