/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.signaturescanner.command;

import com.synopsys.integration.blackduck.configuration.HubServerConfig;
import com.synopsys.integration.blackduck.exception.HubIntegrationException;
import com.synopsys.integration.blackduck.rest.BlackduckRestConnection;
import com.synopsys.integration.blackduck.signaturescanner.command.ScanPaths;
import com.synopsys.integration.blackduck.signaturescanner.command.ScanPathsUtility;
import com.synopsys.integration.exception.EncryptionException;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.connection.RestConnection;
import com.synopsys.integration.rest.request.Request;
import com.synopsys.integration.rest.request.Response;
import com.synopsys.integration.util.CleanupZipExpander;
import com.synopsys.integration.util.IntEnvironmentVariables;
import com.synopsys.integration.util.OperatingSystemType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.lang3.StringUtils;

public class ScannerZipInstaller {
    public static final String DEFAULT_SIGNATURE_SCANNER_DOWNLOAD_URL_SUFFIX = "download/scan.cli.zip";
    public static final String WINDOWS_SIGNATURE_SCANNER_DOWNLOAD_URL_SUFFIX = "download/scan.cli-windows.zip";
    public static final String MAC_SIGNATURE_SCANNER_DOWNLOAD_URL_SUFFIX = "download/scan.cli-macosx.zip";
    public static final String BLACK_DUCK_SIGNATURE_SCANNER_INSTALL_DIRECTORY = "Black_Duck_Scan_Installation";
    public static final String VERSION_FILENAME = "blackDuckVersion.txt";
    private final IntLogger logger;
    private final RestConnection restConnection;
    private final CleanupZipExpander cleanupZipExpander;
    private final ScanPathsUtility scanPathsUtility;
    private final String blackDuckServerUrl;
    private final OperatingSystemType operatingSystemType;

    public static ScannerZipInstaller defaultUtility(IntLogger logger, HubServerConfig hubServerConfig, IntEnvironmentVariables intEnvironmentVariables, OperatingSystemType operatingSystemType) throws EncryptionException {
        ScanPathsUtility scanPathsUtility = new ScanPathsUtility(logger, intEnvironmentVariables, operatingSystemType);
        return ScannerZipInstaller.defaultUtility(logger, hubServerConfig, scanPathsUtility, operatingSystemType);
    }

    public static ScannerZipInstaller defaultUtility(IntLogger logger, HubServerConfig hubServerConfig, ScanPathsUtility scanPathsUtility, OperatingSystemType operatingSystemType) throws EncryptionException {
        BlackduckRestConnection restConnection = hubServerConfig.createRestConnection(logger);
        CleanupZipExpander cleanupZipExpander = new CleanupZipExpander(logger);
        return new ScannerZipInstaller(logger, restConnection, cleanupZipExpander, scanPathsUtility, hubServerConfig.getHubUrl().toString(), operatingSystemType);
    }

    public ScannerZipInstaller(IntLogger logger, RestConnection restConnection, CleanupZipExpander cleanupZipExpander, ScanPathsUtility scanPathsUtility, String blackDuckServerUrl, OperatingSystemType operatingSystemType) {
        if (StringUtils.isBlank((CharSequence)blackDuckServerUrl)) {
            throw new IllegalArgumentException("A Black Duck server url must be provided.");
        }
        this.logger = logger;
        this.restConnection = restConnection;
        this.cleanupZipExpander = cleanupZipExpander;
        this.scanPathsUtility = scanPathsUtility;
        this.blackDuckServerUrl = blackDuckServerUrl;
        this.operatingSystemType = operatingSystemType;
    }

    public void installOrUpdateScanner(File installDirectory) throws HubIntegrationException {
        File scannerExpansionDirectory = new File(installDirectory, BLACK_DUCK_SIGNATURE_SCANNER_INSTALL_DIRECTORY);
        scannerExpansionDirectory.mkdirs();
        File versionFile = null;
        try {
            versionFile = this.retrieveVersionFile(scannerExpansionDirectory);
        }
        catch (IOException e) {
            throw new HubIntegrationException("Trying to install the scanner but could not create the version file: " + e.getMessage());
        }
        String downloadUrl = this.getDownloadUrl();
        try {
            this.downloadIfModified(scannerExpansionDirectory, versionFile, downloadUrl);
        }
        catch (Exception e) {
            throw new HubIntegrationException("The Black Duck Signature Scanner could not be downloaded successfully: " + e.getMessage());
        }
        this.logger.info("The Black Duck Signature Scanner downloaded/found successfully: " + installDirectory.getAbsolutePath());
    }

    private File retrieveVersionFile(File scannerExpansionDirectory) throws IOException {
        File versionFile = new File(scannerExpansionDirectory, VERSION_FILENAME);
        if (!versionFile.exists()) {
            this.logger.info("The version file has not been created yet so creating it now.");
            versionFile.createNewFile();
            versionFile.setLastModified(0L);
        }
        return versionFile;
    }

    private String getDownloadUrl() {
        StringBuilder url = new StringBuilder(this.blackDuckServerUrl);
        if (!this.blackDuckServerUrl.endsWith("/")) {
            url.append("/");
        }
        if (OperatingSystemType.MAC == this.operatingSystemType) {
            url.append(MAC_SIGNATURE_SCANNER_DOWNLOAD_URL_SUFFIX);
        } else if (OperatingSystemType.WINDOWS == this.operatingSystemType) {
            url.append(WINDOWS_SIGNATURE_SCANNER_DOWNLOAD_URL_SUFFIX);
        } else {
            url.append(DEFAULT_SIGNATURE_SCANNER_DOWNLOAD_URL_SUFFIX);
        }
        return url.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadIfModified(File scannerExpansionDirectory, File versionFile, String downloadUrl) throws IOException, IntegrationException, ArchiveException {
        long lastTimeDownloaded = versionFile.lastModified();
        this.logger.debug(String.format("last time downloaded: %d", lastTimeDownloaded));
        Request downloadRequest = new Request.Builder(downloadUrl).build();
        Optional<Response> optionalResponse = this.restConnection.executeGetRequestIfModifiedSince(downloadRequest, lastTimeDownloaded);
        if (optionalResponse.isPresent()) {
            try (Response response = optionalResponse.get();){
                this.logger.info("Downloading the Black Duck Signature Scanner.");
                try (InputStream responseStream = response.getContent();){
                    this.cleanupZipExpander.expand(responseStream, scannerExpansionDirectory);
                }
                long lastModifiedOnServer = response.getLastModified();
                versionFile.setLastModified(lastModifiedOnServer);
                ScanPaths scanPaths = this.scanPathsUtility.determineSignatureScannerPaths(scannerExpansionDirectory.getParentFile());
                File javaExecutable = new File(scanPaths.getPathToJavaExecutable());
                File oneJar = new File(scanPaths.getPathToOneJar());
                File scanExecutable = new File(scanPaths.getPathToScanExecutable());
                javaExecutable.setExecutable(true);
                oneJar.setExecutable(true);
                scanExecutable.setExecutable(true);
                this.logger.info(String.format("Black Duck Signature Scanner downloaded successfully.", new Object[0]));
            }
        }
        this.logger.debug("The Black Duck Signature Scanner has not been modified since it was last downloaded - skipping download.");
    }
}

