/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.signaturescanner.command;

import com.synopsys.integration.blackduck.exception.ScanFailedException;
import com.synopsys.integration.blackduck.service.model.ScannerSplitStream;
import com.synopsys.integration.blackduck.service.model.StreamRedirectThread;
import com.synopsys.integration.blackduck.signaturescanner.command.ScanCommand;
import com.synopsys.integration.blackduck.signaturescanner.command.ScanCommandOutput;
import com.synopsys.integration.blackduck.signaturescanner.command.ScanPaths;
import com.synopsys.integration.blackduck.signaturescanner.command.ScanPathsUtility;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.util.IntEnvironmentVariables;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class ScanCommandCallable
implements Callable<ScanCommandOutput> {
    private static final List<String> DRY_RUN_FILES_TO_KEEP = Arrays.asList("data");
    private final IntLogger logger;
    private final ScanPathsUtility scanPathsUtility;
    private final IntEnvironmentVariables intEnvironmentVariables;
    private final ScanCommand scanCommand;
    private final boolean cleanupOutput;

    public ScanCommandCallable(IntLogger logger, ScanPathsUtility scanPathsUtility, IntEnvironmentVariables intEnvironmentVariables, ScanCommand scanCommand, boolean cleanupOutput) {
        this.logger = logger;
        this.scanPathsUtility = scanPathsUtility;
        this.intEnvironmentVariables = intEnvironmentVariables;
        this.scanCommand = scanCommand;
        this.cleanupOutput = cleanupOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScanCommandOutput call() {
        try {
            ScanPaths scanPaths = this.scanPathsUtility.determineSignatureScannerPaths(this.scanCommand.getInstallDirectory());
            List<String> cmd = this.scanCommand.createCommandForProcessBuilder(this.logger, scanPaths, this.scanCommand.getOutputDirectory().getAbsolutePath());
            this.printCommand(cmd);
            File standardOutFile = this.scanPathsUtility.createStandardOutFile(this.scanCommand.getOutputDirectory());
            try (FileOutputStream outputFileStream = new FileOutputStream(standardOutFile);){
                ScannerSplitStream splitOutputStream = new ScannerSplitStream(this.logger, outputFileStream);
                ProcessBuilder processBuilder = new ProcessBuilder(cmd);
                processBuilder.environment().putAll(this.intEnvironmentVariables.getVariables());
                if (!this.scanCommand.isDryRun()) {
                    if (!StringUtils.isEmpty((CharSequence)this.scanCommand.getApiToken())) {
                        processBuilder.environment().put("BD_HUB_TOKEN", this.scanCommand.getApiToken());
                    } else {
                        processBuilder.environment().put("BD_HUB_PASSWORD", this.scanCommand.getPassword());
                    }
                }
                processBuilder.environment().put("BD_HUB_NO_PROMPT", "true");
                Process hubCliProcess = processBuilder.start();
                StreamRedirectThread redirectThread = new StreamRedirectThread(hubCliProcess.getErrorStream(), splitOutputStream);
                redirectThread.start();
                int returnCode = -1;
                try {
                    returnCode = hubCliProcess.waitFor();
                    redirectThread.join();
                }
                finally {
                    if (hubCliProcess.isAlive()) {
                        hubCliProcess.destroy();
                    }
                    if (redirectThread.isAlive()) {
                        redirectThread.interrupt();
                    }
                }
                splitOutputStream.flush();
                this.logger.info(IOUtils.toString((InputStream)hubCliProcess.getInputStream(), (Charset)StandardCharsets.UTF_8));
                this.logger.info("Black Duck Signature Scanner return code: " + returnCode);
                this.logger.info("You can view the logs at: '" + this.scanCommand.getOutputDirectory().getCanonicalPath() + "'");
                if (returnCode != 0) {
                    throw new ScanFailedException("The scan failed with return code: " + returnCode);
                }
            }
        }
        catch (Exception e) {
            String errorMessage = String.format("There was a problem scanning target '%s': %s", this.scanCommand.getTargetPath(), e.getMessage());
            return ScanCommandOutput.FAILURE(this.logger, this.scanCommand, errorMessage, e);
        }
        if (!this.scanCommand.isDryRun() && this.cleanupOutput) {
            FileUtils.deleteQuietly((File)this.scanCommand.getOutputDirectory());
        } else if (this.scanCommand.isDryRun() && this.cleanupOutput) {
            File[] outputFiles;
            for (File outputFile : outputFiles = this.scanCommand.getOutputDirectory().listFiles()) {
                if (DRY_RUN_FILES_TO_KEEP.contains(outputFile.getName())) continue;
                FileUtils.deleteQuietly((File)outputFile);
            }
        }
        ScanCommandOutput success = ScanCommandOutput.SUCCESS(this.logger, this.scanCommand);
        return success;
    }

    private void printCommand(List<String> cmd) {
        ArrayList<String> cmdToOutput = new ArrayList<String>();
        cmdToOutput.addAll(cmd);
        int passwordIndex = cmdToOutput.indexOf("--password");
        if (passwordIndex > -1) {
            ++passwordIndex;
        }
        int proxyPasswordIndex = -1;
        for (int commandIndex = 0; commandIndex < cmdToOutput.size(); ++commandIndex) {
            String commandParameter = (String)cmdToOutput.get(commandIndex);
            if (!commandParameter.contains("-Dhttp.proxyPassword=")) continue;
            proxyPasswordIndex = commandIndex;
        }
        this.maskIndex(cmdToOutput, passwordIndex);
        this.maskIndex(cmdToOutput, proxyPasswordIndex);
        this.logger.info(String.format("Hub CLI command: %s", StringUtils.join(cmdToOutput, (String)" ")));
    }

    private void maskIndex(List<String> cmd, int indexToMask) {
        if (indexToMask > -1) {
            String cmdToMask = cmd.get(indexToMask);
            Object[] maskedArray = new String[cmdToMask.length()];
            Arrays.fill(maskedArray, "*");
            cmd.set(indexToMask, StringUtils.join((Object[])maskedArray));
        }
    }
}

