/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service.model;

import com.synopsys.integration.blackduck.api.enumeration.PolicyRuleComponentUsageValueSetType;
import com.synopsys.integration.blackduck.api.enumeration.PolicyRuleConditionOperatorType;
import com.synopsys.integration.blackduck.api.enumeration.PolicyRuleConditionType;
import com.synopsys.integration.blackduck.api.enumeration.ReviewStatusType;
import com.synopsys.integration.blackduck.api.generated.component.PolicyRuleExpressionParameter;
import com.synopsys.integration.blackduck.api.generated.component.PolicyRuleExpressionSetView;
import com.synopsys.integration.blackduck.api.generated.component.PolicyRuleExpressionView;
import com.synopsys.integration.blackduck.api.generated.enumeration.LicenseCodeSharingType;
import com.synopsys.integration.blackduck.api.generated.enumeration.PolicyRuleExpressionSetOperatorType;
import com.synopsys.integration.blackduck.api.generated.enumeration.ProjectVersionDistributionType;
import com.synopsys.integration.blackduck.api.generated.enumeration.ProjectVersionPhaseType;
import com.synopsys.integration.blackduck.api.generated.view.ComponentVersionView;
import com.synopsys.integration.blackduck.api.generated.view.ComponentView;
import com.synopsys.integration.blackduck.api.generated.view.LicenseView;
import com.synopsys.integration.blackduck.api.generated.view.ProjectView;
import com.synopsys.integration.blackduck.api.view.MetaHandler;
import com.synopsys.integration.blackduck.exception.HubIntegrationException;
import com.synopsys.integration.rest.RestConstants;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class PolicyRuleExpressionSetBuilder {
    private final List<PolicyRuleExpressionView> expressions = new ArrayList<PolicyRuleExpressionView>();
    private final MetaHandler metaHandler;

    public PolicyRuleExpressionSetBuilder(MetaHandler metaHandler) {
        this.metaHandler = metaHandler;
    }

    public void addProjectCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, ProjectView projectView) throws HubIntegrationException {
        this.addSingleCondition(policyRuleConditionOperator, PolicyRuleConditionType.PROJECT_NAME, this.metaHandler.getHref(projectView));
    }

    public void addComponentVersionCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, ComponentVersionView componentVersionView) throws HubIntegrationException {
        this.addSingleCondition(policyRuleConditionOperator, PolicyRuleConditionType.SINGLE_VERSION, this.metaHandler.getHref(componentVersionView));
    }

    public void addComponentCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, ComponentView componentView) throws HubIntegrationException {
        this.addSingleCondition(policyRuleConditionOperator, PolicyRuleConditionType.SINGLE_VERSION, this.metaHandler.getHref(componentView));
    }

    public void addLicenseCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, LicenseView licenseView) throws HubIntegrationException {
        this.addSingleCondition(policyRuleConditionOperator, PolicyRuleConditionType.SINGLE_LICENSE, this.metaHandler.getHref(licenseView));
    }

    public void addReviewStatusCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, ReviewStatusType reviewType) throws HubIntegrationException {
        this.addSingleObjectCondition(policyRuleConditionOperator, PolicyRuleConditionType.REVIEW_STATUS, (Object)reviewType);
    }

    public void addComponentReleaseDateCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, Date date) throws HubIntegrationException {
        this.addSingleCondition(policyRuleConditionOperator, PolicyRuleConditionType.RELEASE_DATE, RestConstants.formatDate(date));
    }

    public void addNewerVersionCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, Integer count) throws HubIntegrationException {
        this.addSingleObjectCondition(policyRuleConditionOperator, PolicyRuleConditionType.NEWER_VERSIONS_COUNT, count);
    }

    public void addHighSeverityVulnerabilityCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, Integer count) throws HubIntegrationException {
        this.addSingleObjectCondition(policyRuleConditionOperator, PolicyRuleConditionType.HIGH_SEVERITY_VULN_COUNT, count);
    }

    public void addMediumSeverityVulnerabilityCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, Integer count) throws HubIntegrationException {
        this.addSingleObjectCondition(policyRuleConditionOperator, PolicyRuleConditionType.MEDIUM_SEVERITY_VULN_COUNT, count);
    }

    public void addLowSeverityVulnerabilityCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, Integer count) throws HubIntegrationException {
        this.addSingleObjectCondition(policyRuleConditionOperator, PolicyRuleConditionType.LOW_SEVERITY_VULN_COUNT, count);
    }

    public void addProjectTierCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, List<Integer> tiers) throws HubIntegrationException {
        this.addMultiObjectCondition(policyRuleConditionOperator, PolicyRuleConditionType.PROJECT_TIER, tiers);
    }

    public void addPhaseCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, List<ProjectVersionPhaseType> projectVersionPhaseTypes) throws HubIntegrationException {
        this.addMultiObjectCondition(policyRuleConditionOperator, PolicyRuleConditionType.VERSION_PHASE, projectVersionPhaseTypes);
    }

    public void addDistributionCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, List<ProjectVersionDistributionType> projectVersionDistributionTypes) throws HubIntegrationException {
        this.addMultiObjectCondition(policyRuleConditionOperator, PolicyRuleConditionType.VERSION_DISTRIBUTION, projectVersionDistributionTypes);
    }

    public void addComponentUsageCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, List<PolicyRuleComponentUsageValueSetType> componentUsageTypes) throws HubIntegrationException {
        this.addMultiObjectCondition(policyRuleConditionOperator, PolicyRuleConditionType.COMPONENT_USAGE, componentUsageTypes);
    }

    public void addLicenseFamilyCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, List<LicenseCodeSharingType> licenseCodeSharingTypes) throws HubIntegrationException {
        this.addMultiObjectCondition(policyRuleConditionOperator, PolicyRuleConditionType.LICENSE_FAMILY, licenseCodeSharingTypes);
    }

    public void addSingleObjectCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, PolicyRuleConditionType policyRuleConditionType, Object object) throws HubIntegrationException {
        ArrayList<String> values = new ArrayList<String>(1);
        values.add(object.toString());
        this.addMultiCondition(policyRuleConditionOperator, PolicyRuleConditionType.PROJECT_NAME, values);
    }

    public void addMultiObjectCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, PolicyRuleConditionType policyRuleConditionType, List<?> objectValues) throws HubIntegrationException {
        ArrayList<String> values = new ArrayList<String>(objectValues.size());
        for (Object object : objectValues) {
            values.add(object.toString());
        }
        this.addMultiCondition(policyRuleConditionOperator, PolicyRuleConditionType.PROJECT_NAME, values);
    }

    public void addSingleCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, PolicyRuleConditionType policyRuleConditionType, String value) throws HubIntegrationException {
        ArrayList<String> values = new ArrayList<String>(1);
        values.add(value);
        this.addMultiCondition(policyRuleConditionOperator, policyRuleConditionType, values);
    }

    public void addMultiCondition(PolicyRuleConditionOperatorType policyRuleConditionOperator, PolicyRuleConditionType policyRuleConditionType, List<String> values) throws HubIntegrationException {
        PolicyRuleExpressionParameter expressionParameter = new PolicyRuleExpressionParameter();
        expressionParameter.values = values;
        PolicyRuleExpressionView expression = new PolicyRuleExpressionView();
        expression.name = policyRuleConditionType.toString();
        expression.operation = policyRuleConditionOperator.toString();
        expression.parameters = expressionParameter;
        this.expressions.add(expression);
    }

    public PolicyRuleExpressionSetView createPolicyRuleExpressionSetView() {
        return this.createPolicyRuleExpressionSetView(PolicyRuleExpressionSetOperatorType.AND);
    }

    public PolicyRuleExpressionSetView createPolicyRuleExpressionSetView(PolicyRuleExpressionSetOperatorType expressionOperatorType) {
        PolicyRuleExpressionSetView expressionSet = new PolicyRuleExpressionSetView();
        expressionSet.operator = expressionOperatorType;
        expressionSet.expressions = this.expressions;
        return expressionSet;
    }
}

