/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service.model;

import com.synopsys.integration.blackduck.exception.HubIntegrationException;
import com.synopsys.integration.blackduck.service.model.RequestFactory;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.LogLevel;
import com.synopsys.integration.log.PrintStreamIntLogger;
import com.synopsys.integration.rest.connection.UnauthenticatedRestConnection;
import com.synopsys.integration.rest.connection.UnauthenticatedRestConnectionBuilder;
import com.synopsys.integration.rest.exception.IntegrationRestException;
import com.synopsys.integration.rest.proxy.ProxyInfo;
import com.synopsys.integration.rest.request.Request;
import com.synopsys.integration.rest.request.Response;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;

public class HubServerVerifier {
    public void verifyIsHubServer(URL hubURL, ProxyInfo hubProxyInfo, boolean alwaysTrustServerCertificate, int timeoutSeconds) throws IntegrationException {
        UnauthenticatedRestConnectionBuilder connectionBuilder = new UnauthenticatedRestConnectionBuilder();
        connectionBuilder.setLogger(new PrintStreamIntLogger(System.out, LogLevel.INFO));
        connectionBuilder.setBaseUrl(hubURL.toString());
        connectionBuilder.setTimeout(timeoutSeconds);
        connectionBuilder.setAlwaysTrustServerCertificate(alwaysTrustServerCertificate);
        if (hubProxyInfo != null) {
            connectionBuilder.applyProxyInfo(hubProxyInfo);
        }
        UnauthenticatedRestConnection restConnection = (UnauthenticatedRestConnection)connectionBuilder.build();
        try {
            URL downloadURL;
            Request request = new Request.Builder(hubURL.toURI().toString()).build();
            try {
                Response response = restConnection.executeRequest(request);
                Throwable throwable = null;
                if (response != null) {
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        response.close();
                    }
                }
            }
            catch (IntegrationRestException e) {
                if (e.getHttpStatusCode() != 401 && e.getHttpStatusCode() != 403) {
                    throw e;
                }
            }
            catch (IOException e) {
                throw new IntegrationException(e.getMessage(), e);
            }
            try {
                downloadURL = new URL(hubURL, "download/scan.cli.zip");
            }
            catch (MalformedURLException e) {
                throw new HubIntegrationException("Error constructing the download URL : " + e.getMessage(), e);
            }
            String downloadUri = downloadURL.toString();
            request = RequestFactory.createCommonGetRequest(downloadUri);
            try {
                Response response = restConnection.executeRequest(request);
                Throwable throwable = null;
                if (response != null) {
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        response.close();
                    }
                }
            }
            catch (IntegrationRestException e) {
                throw new HubIntegrationException("The Url does not appear to be a Hub server :" + downloadUri + ", because: " + e.getHttpStatusCode() + " : " + e.getHttpStatusMessage(), e);
            }
            catch (IntegrationException e) {
                throw new HubIntegrationException("The Url does not appear to be a Hub server :" + downloadUri + ", because: " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new IntegrationException(e.getMessage(), e);
            }
        }
        catch (URISyntaxException e) {
            throw new IntegrationException("The Url does not appear to be a Hub server :" + hubURL.toString() + ", because: " + e.getMessage(), e);
        }
    }
}

