/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service.bucket;

import com.synopsys.integration.blackduck.api.UriSingleResponse;
import com.synopsys.integration.blackduck.api.core.HubResponse;
import com.synopsys.integration.blackduck.service.bucket.HubBucketItem;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class HubBucket {
    private final Map<String, HubBucketItem<HubResponse>> bucket = new ConcurrentHashMap<String, HubBucketItem<HubResponse>>();

    public boolean contains(String uri) {
        return this.bucket.containsKey(uri);
    }

    public Set<String> getAvailableUris() {
        return this.bucket.keySet();
    }

    public HubBucketItem<HubResponse> get(String uri) {
        return this.bucket.get(uri);
    }

    public <T extends HubResponse> T get(String uri, Class<T> responseClass) {
        UriSingleResponse<T> uriSingleResponse = new UriSingleResponse<T>(uri, responseClass);
        return this.get(uriSingleResponse);
    }

    public <T extends HubResponse> T get(UriSingleResponse<T> uriSingleResponse) {
        HubResponse hubResponse;
        Optional<HubResponse> optionalHubResponse;
        HubBucketItem<HubResponse> bucketItem;
        String uri = uriSingleResponse.uri;
        if (this.contains(uri) && (bucketItem = this.get(uri)).hasValidResponse() && (optionalHubResponse = bucketItem.getHubResponse()).isPresent() && (hubResponse = optionalHubResponse.get()).getClass().equals(uriSingleResponse.responseClass)) {
            return this.getResponseFromBucket(bucketItem);
        }
        return null;
    }

    private <T extends HubResponse> T getResponseFromBucket(HubBucketItem<HubResponse> bucketItem) {
        return (T)((HubResponse)bucketItem.getHubResponse().orElse(null));
    }

    public Optional<HubResponse> getResponse(String uri) {
        return this.bucket.get(uri).getHubResponse();
    }

    public Optional<Exception> getError(String uri) {
        return this.bucket.get(uri).getE();
    }

    public void addValid(String uri, HubResponse hubResponse) {
        this.bucket.put(uri, new HubBucketItem<HubResponse>(uri, hubResponse));
    }

    public void addError(String uri, Exception e) {
        this.bucket.put(uri, new HubBucketItem(uri, e));
    }

    public HubBucketItem<HubResponse> remove(String uri) {
        return this.bucket.remove(uri);
    }
}

