/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugin.blackduck;

import com.blackducksoftware.integration.exception.EncryptionException;
import com.blackducksoftware.integration.hub.builder.HubServerConfigBuilder;
import com.blackducksoftware.integration.hub.exception.HubIntegrationException;
import com.blackducksoftware.integration.hub.global.HubServerConfig;
import com.blackducksoftware.integration.hub.rest.CredentialsRestConnection;
import com.blackducksoftware.integration.hub.service.HubServicesFactory;
import com.blackducksoftware.integration.log.IntLogger;
import com.blackducksoftware.integration.log.LogLevel;
import com.blackducksoftware.integration.log.PrintStreamIntLogger;

public class RestConnectionHelper {
    private String hubServerUrl;
    private String username;
    private String password;
    private boolean trustCertificate;
    private String proxyHost;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;

    public RestConnectionHelper(String hubServerUrl, String username, String password, String proxyHost, String proxyPort, String proxyUsername, String proxyPassword, Boolean trustCertificate) {
        this.hubServerUrl = hubServerUrl;
        this.username = username;
        this.password = password;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.trustCertificate = trustCertificate;
    }

    public HubServerConfig getHubServerConfig() {
        HubServerConfigBuilder builder = new HubServerConfigBuilder();
        builder.setHubUrl(this.hubServerUrl);
        builder.setUsername(this.username);
        builder.setPassword(this.password);
        builder.setProxyHost(this.proxyHost);
        builder.setProxyPort(this.proxyPort);
        builder.setProxyUsername(this.proxyUsername);
        builder.setProxyPassword(this.proxyPassword);
        builder.setAlwaysTrustServerCertificate(this.trustCertificate);
        return builder.build();
    }

    public CredentialsRestConnection getIntegrationHubRestConnection() throws IllegalArgumentException, EncryptionException, HubIntegrationException {
        return this.getRestConnection(this.getHubServerConfig());
    }

    public CredentialsRestConnection getRestConnection(HubServerConfig serverConfig) throws IllegalArgumentException, EncryptionException, HubIntegrationException {
        return this.getRestConnection(serverConfig, LogLevel.INFO);
    }

    public CredentialsRestConnection getRestConnection(HubServerConfig serverConfig, LogLevel logLevel) throws IllegalArgumentException, EncryptionException, HubIntegrationException {
        return serverConfig.createCredentialsRestConnection(new PrintStreamIntLogger(System.out, logLevel));
    }

    public HubServicesFactory createHubServicesFactory() throws IllegalArgumentException, EncryptionException, HubIntegrationException {
        return this.createHubServicesFactory(LogLevel.INFO);
    }

    public HubServicesFactory createHubServicesFactory(LogLevel logLevel) throws IllegalArgumentException, EncryptionException, HubIntegrationException {
        return this.createHubServicesFactory(this.createIntLogger(logLevel));
    }

    public IntLogger createIntLogger(LogLevel logLevel) {
        return new PrintStreamIntLogger(System.out, logLevel);
    }

    public HubServicesFactory createHubServicesFactory(IntLogger logger) throws IllegalArgumentException, EncryptionException, HubIntegrationException {
        CredentialsRestConnection restConnection = this.getIntegrationHubRestConnection();
        restConnection.logger = logger;
        HubServicesFactory hubServicesFactory = new HubServicesFactory(restConnection);
        return hubServicesFactory;
    }
}

