/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.service;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.api.view.MetaHandler;
import com.blackducksoftware.integration.hub.model.HubView;
import com.blackducksoftware.integration.hub.request.HubRequest;
import com.blackducksoftware.integration.hub.request.HubRequestFactory;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;

public class HubViewTransformer {
    private final HubRequestFactory hubRequestFactory;
    private final MetaHandler metaHandler;
    private final JsonParser jsonParser;
    private final Gson gson;

    public HubViewTransformer(HubRequestFactory hubRequestFactory, MetaHandler metaHandler, JsonParser jsonParser, Gson gson) {
        this.hubRequestFactory = hubRequestFactory;
        this.metaHandler = metaHandler;
        this.jsonParser = jsonParser;
        this.gson = gson;
    }

    public <T extends HubView> T getViewFromLinkSafely(HubView hubView, String metaLinkRef, Class<T> clazz) throws IntegrationException {
        return this.getViewFromLinkSafely(hubView, metaLinkRef, clazz, null);
    }

    public <T extends HubView> T getViewFromLinkSafely(HubView hubView, String metaLinkRef, Class<T> clazz, String mediaType) throws IntegrationException {
        if (!this.metaHandler.hasLink(hubView, metaLinkRef)) {
            return this.getViewFromLink(hubView, metaLinkRef, clazz, mediaType);
        }
        return null;
    }

    public <T extends HubView> T getViewFromLink(HubView hubView, String metaLinkRef, Class<T> clazz) throws IntegrationException {
        return this.getViewFromLink(hubView, metaLinkRef, clazz, null);
    }

    public <T extends HubView> T getViewFromLink(HubView hubView, String metaLinkRef, Class<T> clazz, String mediaType) throws IntegrationException {
        String link = this.metaHandler.getFirstLink(hubView, metaLinkRef);
        return this.getView(link, clazz, mediaType);
    }

    public <T extends HubView> T getView(HubRequest request, Class<T> clazz) throws IntegrationException {
        return this.getView(request, clazz, null);
    }

    public <T extends HubView> T getView(String url, Class<T> clazz) throws IntegrationException {
        return this.getView(url, clazz, null);
    }

    public <T extends HubView> T getView(String url, Class<T> clazz, String mediaType) throws IntegrationException {
        HubRequest request = this.hubRequestFactory.createRequest(url);
        return this.getView(request, clazz, mediaType);
    }

    public <T extends HubView> T getView(HubRequest request, Class<T> clazz, String mediaType) throws IntegrationException {
        try (Response response = null;){
            response = StringUtils.isNotBlank(mediaType) ? request.executeGet(mediaType) : request.executeGet();
            String jsonResponse = response.body().string();
            JsonObject jsonObject = this.jsonParser.parse(jsonResponse).getAsJsonObject();
            T t = this.getViewAs(jsonObject, clazz);
            return t;
        }
    }

    public <T extends HubView> T getViewAs(JsonElement view, Class<T> clazz) {
        HubView hubItem = (HubView)this.gson.fromJson(view, clazz);
        hubItem.json = this.gson.toJson(view);
        return (T)hubItem;
    }

    public <T extends HubView> T getViewAs(String view, Class<T> clazz) {
        HubView hubItem = (HubView)this.gson.fromJson(view, clazz);
        hubItem.json = view;
        return (T)hubItem;
    }
}

