/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.rest;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.proxy.ProxyInfo;
import com.blackducksoftware.integration.hub.rest.RestConnection;
import com.blackducksoftware.integration.hub.rest.exception.IntegrationRestException;
import com.blackducksoftware.integration.log.IntLogger;
import java.io.Closeable;
import java.io.IOException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.HttpUrl;
import okhttp3.JavaNetCookieJar;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class CredentialsRestConnection
extends RestConnection {
    private final String hubUsername;
    private final String hubPassword;

    public CredentialsRestConnection(IntLogger logger, URL hubBaseUrl, String hubUsername, String hubPassword, int timeout, ProxyInfo proxyInfo) {
        super(logger, hubBaseUrl, timeout, proxyInfo);
        this.hubUsername = hubUsername;
        this.hubPassword = hubPassword;
    }

    @Override
    public void addBuilderAuthentication() throws IntegrationRestException {
        if (StringUtils.isNotBlank(this.hubUsername) && StringUtils.isNotBlank(this.hubPassword)) {
            CookieManager cookieManager = new CookieManager();
            cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
            this.builder.cookieJar(new JavaNetCookieJar(cookieManager));
        }
    }

    @Override
    public void clientAuthenticate() throws IntegrationException {
        ArrayList<String> segments = new ArrayList<String>();
        segments.add("j_spring_security_check");
        HttpUrl httpUrl = this.createHttpUrl(segments, null);
        HashMap<String, String> content = new HashMap<String, String>();
        if (StringUtils.isNotBlank(this.hubUsername) && StringUtils.isNotBlank(this.hubPassword)) {
            Response response;
            block6: {
                content.put("j_username", this.hubUsername);
                content.put("j_password", this.hubPassword);
                Request request = this.createPostRequest(httpUrl, this.createEncodedFormBody(content));
                response = null;
                try {
                    this.logRequestHeaders(request);
                    response = this.getClient().newCall(request).execute();
                    this.logResponseHeaders(response);
                    if (!response.isSuccessful()) {
                        throw new IntegrationRestException(response.code(), response.message(), String.format("Connection Error: %s %s", response.code(), response.message()));
                    }
                    String csrfToken = response.header("X-CSRF-TOKEN");
                    if (!StringUtils.isNotBlank(csrfToken)) break block6;
                    this.commonRequestHeaders.put("X-CSRF-TOKEN", csrfToken);
                }
                catch (IOException e) {
                    try {
                        throw new IntegrationException(e.getMessage(), e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(response);
                        throw throwable;
                    }
                }
            }
            IOUtils.closeQuietly((Closeable)response);
        }
    }
}

