/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.dataservice.report;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.HubSupportHelper;
import com.blackducksoftware.integration.hub.api.aggregate.bom.AggregateBomService;
import com.blackducksoftware.integration.hub.api.project.ProjectService;
import com.blackducksoftware.integration.hub.api.project.version.ProjectVersionService;
import com.blackducksoftware.integration.hub.api.report.AggregateBomViewEntry;
import com.blackducksoftware.integration.hub.api.report.ReportCategoriesEnum;
import com.blackducksoftware.integration.hub.api.report.ReportService;
import com.blackducksoftware.integration.hub.api.report.VersionReport;
import com.blackducksoftware.integration.hub.capability.HubCapabilitiesEnum;
import com.blackducksoftware.integration.hub.exception.HubIntegrationException;
import com.blackducksoftware.integration.hub.model.enumeration.BomComponentPolicyStatusApprovalStatusEnum;
import com.blackducksoftware.integration.hub.model.enumeration.ReportFormatEnum;
import com.blackducksoftware.integration.hub.model.enumeration.RiskCountEnum;
import com.blackducksoftware.integration.hub.model.view.BomComponentPolicyStatusView;
import com.blackducksoftware.integration.hub.model.view.PolicyRuleView;
import com.blackducksoftware.integration.hub.model.view.ProjectVersionView;
import com.blackducksoftware.integration.hub.model.view.ProjectView;
import com.blackducksoftware.integration.hub.model.view.VersionBomComponentView;
import com.blackducksoftware.integration.hub.model.view.components.RiskCountView;
import com.blackducksoftware.integration.hub.report.RiskReportWriter;
import com.blackducksoftware.integration.hub.report.api.BomComponent;
import com.blackducksoftware.integration.hub.report.api.PolicyRule;
import com.blackducksoftware.integration.hub.report.api.ReportData;
import com.blackducksoftware.integration.hub.report.exception.RiskReportException;
import com.blackducksoftware.integration.hub.report.pdf.PDFBoxWriter;
import com.blackducksoftware.integration.hub.rest.RestConnection;
import com.blackducksoftware.integration.hub.service.HubService;
import com.blackducksoftware.integration.log.IntLogger;
import com.blackducksoftware.integration.util.IntegrationEscapeUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class RiskReportDataService
extends HubService {
    private final IntLogger logger;
    private final ProjectService projectRequestService;
    private final ProjectVersionService projectVersionRequestService;
    private final ReportService reportRequestService;
    private final AggregateBomService bomRequestService;
    private final HubSupportHelper hubSupportHelper;
    private final IntegrationEscapeUtil escapeUtil;

    public RiskReportDataService(IntLogger logger, RestConnection restConnection, ProjectService projectRequestService, ProjectVersionService projectVersionRequestService, ReportService reportRequestService, AggregateBomService bomRequestService, HubSupportHelper hubSupportHelper, IntegrationEscapeUtil escapeUtil) {
        super(restConnection);
        this.logger = logger;
        this.projectRequestService = projectRequestService;
        this.projectVersionRequestService = projectVersionRequestService;
        this.reportRequestService = reportRequestService;
        this.bomRequestService = bomRequestService;
        this.hubSupportHelper = hubSupportHelper;
        this.escapeUtil = escapeUtil;
    }

    public String getNoticesReportData(String projectName, String projectVersionName) throws IntegrationException {
        ProjectView project = this.projectRequestService.getProjectByName(projectName);
        ProjectVersionView version = this.projectVersionRequestService.getProjectVersion(project, projectVersionName);
        return this.getNoticesReportData(project, version);
    }

    public String getNoticesReportData(ProjectView project, ProjectVersionView version) throws IntegrationException {
        this.logger.trace("Getting the Notices Report Contents using the Report Rest Server");
        return this.reportRequestService.generateHubNoticesReport(version, ReportFormatEnum.TEXT);
    }

    public File createNoticesReportFile(File outputDirectory, String projectName, String projectVersionName) throws IntegrationException {
        return this.createNoticesReportFile(outputDirectory, this.getNoticesReportData(projectName, projectVersionName), projectName, projectVersionName);
    }

    public File createNoticesReportFile(File outputDirectory, ProjectView project, ProjectVersionView version) throws IntegrationException {
        return this.createNoticesReportFile(outputDirectory, this.getNoticesReportData(project, version), project.name, version.versionName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File createNoticesReportFile(File outputDirectory, String noticesReportContent, String projectName, String projectVersionName) throws HubIntegrationException {
        if (noticesReportContent == null) {
            return null;
        }
        String escapedProjectName = this.escapeUtil.escapeForUri(projectName);
        String escapedProjectVersionName = this.escapeUtil.escapeForUri(projectVersionName);
        File noticesReportFile = new File(outputDirectory, escapedProjectName + "_" + escapedProjectVersionName + "_Hub_Notices_Report.txt");
        if (noticesReportFile.exists()) {
            noticesReportFile.delete();
        }
        try (FileWriter writer = new FileWriter(noticesReportFile);){
            this.logger.trace("Creating Notices Report in : " + outputDirectory.getCanonicalPath());
            writer.write(noticesReportContent);
            this.logger.trace("Created Notices Report : " + noticesReportFile.getCanonicalPath());
            File file = noticesReportFile;
            return file;
        }
        catch (IOException e) {
            throw new HubIntegrationException(e.getMessage(), e);
        }
    }

    public ReportData getRiskReportData(String projectName, String projectVersionName) throws IntegrationException {
        ProjectView project = this.projectRequestService.getProjectByName(projectName);
        ProjectVersionView version = this.projectVersionRequestService.getProjectVersion(project, projectVersionName);
        return this.getRiskReportData(project, version);
    }

    public ReportData getRiskReportData(ProjectView project, ProjectVersionView version) throws IntegrationException {
        String originalProjectUrl = this.getHref(project);
        String originalVersionUrl = this.getHref(version);
        ReportData reportData = new ReportData();
        reportData.setProjectName(project.name);
        reportData.setProjectURL(this.getReportProjectUrl(originalProjectUrl));
        reportData.setProjectVersion(version.versionName);
        reportData.setProjectVersionURL(this.getReportVersionUrl(originalVersionUrl, false));
        reportData.setPhase(version.phase.toString());
        reportData.setDistribution(version.distribution.toString());
        ArrayList<BomComponent> components = new ArrayList<BomComponent>();
        if (this.hubSupportHelper.hasCapability(HubCapabilitiesEnum.AGGREGATE_BOM_REST_SERVER)) {
            this.logger.trace("Getting the Report Contents using the Aggregate Bom Rest Server");
            List<VersionBomComponentView> bomEntries = this.bomRequestService.getBomEntries(version);
            boolean policyFailure = false;
            for (VersionBomComponentView bomEntry : bomEntries) {
                BomComponent component = this.createBomComponentFromBomComponentView(bomEntry);
                String policyStatus = bomEntry.approvalStatus;
                if (StringUtils.isBlank(policyStatus)) {
                    String componentPolicyStatusURL = null;
                    componentPolicyStatusURL = !StringUtils.isBlank(bomEntry.componentVersion) ? this.getComponentPolicyURL(originalVersionUrl, bomEntry.componentVersion) : this.getComponentPolicyURL(originalVersionUrl, bomEntry.component);
                    if (!policyFailure) {
                        try {
                            BomComponentPolicyStatusView bomPolicyStatus = this.getView(componentPolicyStatusURL, BomComponentPolicyStatusView.class);
                            policyStatus = bomPolicyStatus.approvalStatus.toString();
                        }
                        catch (IntegrationException e) {
                            policyFailure = true;
                            this.logger.debug("Could not get the component policy status, the Hub policy module is not enabled");
                        }
                    }
                }
                component.setPolicyStatus(policyStatus);
                this.addPolicyRuleInfo(component, bomEntry);
                components.add(component);
            }
        } else {
            this.logger.trace("Getting the Report Contents using the Report Rest Server");
            ReportCategoriesEnum[] categories = new ReportCategoriesEnum[]{ReportCategoriesEnum.VERSION, ReportCategoriesEnum.COMPONENTS};
            VersionReport versionReport = this.reportRequestService.generateHubReport(version, ReportFormatEnum.JSON, categories);
            List<AggregateBomViewEntry> bomEntries = versionReport.getAggregateBomViewEntries();
            for (AggregateBomViewEntry bomEntry : bomEntries) {
                BomComponent component = this.createBomComponentFromBomViewEntry(versionReport, bomEntry);
                components.add(component);
            }
        }
        reportData.setComponents(components);
        return reportData;
    }

    public void createReportFiles(File outputDirectory, String projectName, String projectVersionName) throws IntegrationException {
        ReportData reportData = this.getRiskReportData(projectName, projectVersionName);
        this.createReportFiles(outputDirectory, reportData);
    }

    public void createReportFiles(File outputDirectory, ProjectView project, ProjectVersionView version) throws IntegrationException {
        ReportData reportData = this.getRiskReportData(project, version);
        this.createReportFiles(outputDirectory, reportData);
    }

    public void createReportFiles(File outputDirectory, ReportData reportData) throws HubIntegrationException {
        try {
            this.logger.trace("Creating Risk Report Files in : " + outputDirectory.getCanonicalPath());
            RiskReportWriter writer = new RiskReportWriter();
            writer.createHtmlReportFiles(outputDirectory, reportData);
        }
        catch (RiskReportException | IOException e) {
            throw new HubIntegrationException(e.getMessage(), e);
        }
    }

    public File createReportPdfFile(File outputDirectory, String projectName, String projectVersionName) throws IntegrationException {
        ReportData reportData = this.getRiskReportData(projectName, projectVersionName);
        return this.createReportPdfFile(outputDirectory, reportData);
    }

    public File createReportPdfFile(File outputDirectory, ProjectView project, ProjectVersionView version) throws IntegrationException {
        ReportData reportData = this.getRiskReportData(project, version);
        return this.createReportPdfFile(outputDirectory, reportData);
    }

    public File createReportPdfFile(File outputDirectory, ReportData reportData) throws HubIntegrationException {
        try {
            this.logger.trace("Creating Risk Report Pdf in : " + outputDirectory.getCanonicalPath());
            PDFBoxWriter writer = new PDFBoxWriter(this.logger);
            File pdfFile = writer.createPDFReportFile(outputDirectory, reportData);
            this.logger.trace("Created Risk Report Pdf : " + pdfFile.getCanonicalPath());
            return pdfFile;
        }
        catch (RiskReportException | IOException e) {
            throw new HubIntegrationException(e.getMessage(), e);
        }
    }

    private String getComponentPolicyURL(String versionURL, String componentURL) {
        String componentVersionSegments = componentURL.substring(componentURL.indexOf("components"));
        return versionURL + "/" + componentVersionSegments + "/" + "policy-status";
    }

    private BomComponent createBomComponentFromBomViewEntry(VersionReport report, AggregateBomViewEntry bomEntry) {
        BomComponent component = new BomComponent();
        if (bomEntry.getProducerProject() != null) {
            component.setComponentName(bomEntry.getProducerProject().getName());
            component.setComponentURL(report.getComponentUrl(bomEntry));
        }
        if (bomEntry.getProducerReleases() != null && !bomEntry.getProducerReleases().isEmpty()) {
            component.setComponentVersion(bomEntry.getProducerReleases().get(0).getVersion());
            component.setComponentVersionURL(report.getVersionUrl(bomEntry));
        }
        component.setLicense(bomEntry.getLicensesDisplay());
        component.setPolicyStatus(bomEntry.getPolicyApprovalStatusEnum().toString());
        if (bomEntry.getVulnerabilityRisk() != null) {
            component.setSecurityRiskHighCount(bomEntry.getVulnerabilityRisk().getHIGH());
            component.setSecurityRiskMediumCount(bomEntry.getVulnerabilityRisk().getMEDIUM());
            component.setSecurityRiskLowCount(bomEntry.getVulnerabilityRisk().getLOW());
        }
        if (bomEntry.getLicenseRisk() != null) {
            component.setLicenseRiskHighCount(bomEntry.getLicenseRisk().getHIGH());
            component.setLicenseRiskMediumCount(bomEntry.getLicenseRisk().getMEDIUM());
            component.setLicenseRiskLowCount(bomEntry.getLicenseRisk().getLOW());
        }
        if (bomEntry.getOperationalRisk() != null) {
            component.setOperationalRiskHighCount(bomEntry.getOperationalRisk().getHIGH());
            component.setOperationalRiskMediumCount(bomEntry.getOperationalRisk().getMEDIUM());
            component.setOperationalRiskLowCount(bomEntry.getOperationalRisk().getLOW());
        }
        return component;
    }

    private BomComponent createBomComponentFromBomComponentView(VersionBomComponentView bomEntry) {
        BomComponent component = new BomComponent();
        component.setComponentName(bomEntry.componentName);
        component.setComponentURL(this.getReportProjectUrl(bomEntry.component));
        component.setComponentVersion(bomEntry.componentVersionName);
        component.setComponentVersionURL(this.getReportVersionUrl(bomEntry.componentVersion, true));
        component.setLicense(bomEntry.licenses.get((int)0).licenseDisplay);
        if (bomEntry.securityRiskProfile != null && bomEntry.securityRiskProfile.counts != null && !bomEntry.securityRiskProfile.counts.isEmpty()) {
            for (RiskCountView count : bomEntry.securityRiskProfile.counts) {
                if (count.countType == RiskCountEnum.HIGH && count.count > 0) {
                    component.setSecurityRiskHighCount(count.count);
                    continue;
                }
                if (count.countType == RiskCountEnum.MEDIUM && count.count > 0) {
                    component.setSecurityRiskMediumCount(count.count);
                    continue;
                }
                if (count.countType != RiskCountEnum.LOW || count.count <= 0) continue;
                component.setSecurityRiskLowCount(count.count);
            }
        }
        if (bomEntry.licenseRiskProfile != null && bomEntry.licenseRiskProfile.counts != null && !bomEntry.licenseRiskProfile.counts.isEmpty()) {
            for (RiskCountView count : bomEntry.licenseRiskProfile.counts) {
                if (count.countType == RiskCountEnum.HIGH && count.count > 0) {
                    component.setLicenseRiskHighCount(count.count);
                    continue;
                }
                if (count.countType == RiskCountEnum.MEDIUM && count.count > 0) {
                    component.setLicenseRiskMediumCount(count.count);
                    continue;
                }
                if (count.countType != RiskCountEnum.LOW || count.count <= 0) continue;
                component.setLicenseRiskLowCount(count.count);
            }
        }
        if (bomEntry.operationalRiskProfile != null && bomEntry.operationalRiskProfile.counts != null && !bomEntry.operationalRiskProfile.counts.isEmpty()) {
            for (RiskCountView count : bomEntry.operationalRiskProfile.counts) {
                if (count.countType == RiskCountEnum.HIGH && count.count > 0) {
                    component.setOperationalRiskHighCount(count.count);
                    continue;
                }
                if (count.countType == RiskCountEnum.MEDIUM && count.count > 0) {
                    component.setOperationalRiskMediumCount(count.count);
                    continue;
                }
                if (count.countType != RiskCountEnum.LOW || count.count <= 0) continue;
                component.setOperationalRiskLowCount(count.count);
            }
        }
        return component;
    }

    public void addPolicyRuleInfo(BomComponent component, VersionBomComponentView bomEntry) throws IntegrationException {
        BomComponentPolicyStatusApprovalStatusEnum status;
        if (bomEntry != null && StringUtils.isNotBlank(bomEntry.approvalStatus) && (status = BomComponentPolicyStatusApprovalStatusEnum.valueOf(bomEntry.approvalStatus)) == BomComponentPolicyStatusApprovalStatusEnum.IN_VIOLATION) {
            String policyRuleLink = this.getFirstLink(bomEntry, "policy-rules");
            List<PolicyRuleView> rules = this.getAllViews(policyRuleLink, PolicyRuleView.class);
            ArrayList<PolicyRule> rulesViolated = new ArrayList<PolicyRule>();
            for (PolicyRuleView policyRuleView : rules) {
                PolicyRule ruleViolated = new PolicyRule();
                ruleViolated.setName(policyRuleView.name);
                ruleViolated.setDescription(policyRuleView.description);
                rulesViolated.add(ruleViolated);
            }
            component.setPolicyRulesViolated(rulesViolated);
        }
    }

    private String getBaseUrl() {
        return this.getHubBaseUrl().toString();
    }

    private String getReportProjectUrl(String projectURL) {
        if (projectURL == null) {
            return null;
        }
        String projectId = projectURL.substring(projectURL.lastIndexOf("/") + 1);
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(this.getBaseUrl());
        urlBuilder.append("#");
        urlBuilder.append("projects/id:");
        urlBuilder.append(projectId);
        return urlBuilder.toString();
    }

    private String getReportVersionUrl(String versionURL, boolean isComponent) {
        if (versionURL == null) {
            return null;
        }
        String versionId = versionURL.substring(versionURL.lastIndexOf("/") + 1);
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(this.getBaseUrl());
        urlBuilder.append("#");
        urlBuilder.append("versions/id:");
        urlBuilder.append(versionId);
        if (!isComponent) {
            urlBuilder.append("/view:bom");
        }
        return urlBuilder.toString();
    }
}

