/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.dataservice.extension;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.api.extension.ExtensionConfigService;
import com.blackducksoftware.integration.hub.api.extension.ExtensionUserOptionService;
import com.blackducksoftware.integration.hub.api.user.UserService;
import com.blackducksoftware.integration.hub.dataservice.extension.item.UserConfigItem;
import com.blackducksoftware.integration.hub.dataservice.extension.transformer.UserConfigTransform;
import com.blackducksoftware.integration.hub.dataservice.parallel.ParallelResourceProcessor;
import com.blackducksoftware.integration.hub.dataservice.parallel.ParallelResourceProcessorResults;
import com.blackducksoftware.integration.hub.model.view.ExternalExtensionConfigValueView;
import com.blackducksoftware.integration.hub.model.view.ExternalExtensionUserView;
import com.blackducksoftware.integration.hub.model.view.ExternalExtensionView;
import com.blackducksoftware.integration.hub.rest.RestConnection;
import com.blackducksoftware.integration.hub.service.HubService;
import com.blackducksoftware.integration.log.IntLogger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ExtensionConfigDataService
extends HubService {
    private final ExtensionConfigService extensionConfigRequestService;
    private final UserConfigTransform userConfigTransform;
    private final ExtensionUserOptionService extensionUserOptionRequestService;
    private final ParallelResourceProcessor<UserConfigItem, ExternalExtensionUserView> parallelProcessor;

    public ExtensionConfigDataService(IntLogger logger, RestConnection restConnection, UserService userRequestService, ExtensionConfigService extensionConfigRequestService, ExtensionUserOptionService extensionUserOptionRequestService) {
        super(restConnection);
        this.extensionConfigRequestService = extensionConfigRequestService;
        this.extensionUserOptionRequestService = extensionUserOptionRequestService;
        this.userConfigTransform = new UserConfigTransform(userRequestService, extensionConfigRequestService);
        this.parallelProcessor = new ParallelResourceProcessor(logger);
        this.parallelProcessor.addTransform(ExternalExtensionUserView.class, this.userConfigTransform);
    }

    public Map<String, ExternalExtensionConfigValueView> getGlobalConfigMap(String extensionUrl) throws IntegrationException {
        HashMap<String, ExternalExtensionConfigValueView> globalConfigMap = new HashMap();
        ExternalExtensionView extension = this.getView(extensionUrl, ExternalExtensionView.class);
        String globalOptionsLink = this.getFirstLink(extension, "global-options");
        globalConfigMap = this.createGlobalConfigMap(globalOptionsLink);
        return globalConfigMap;
    }

    public ParallelResourceProcessorResults<UserConfigItem> getUserConfigList(String extensionUrl) throws IntegrationException {
        ExternalExtensionView extension = this.getView(extensionUrl, ExternalExtensionView.class);
        String userOptionsLink = this.getFirstLink(extension, "user-options");
        List<ExternalExtensionUserView> userOptionList = this.extensionUserOptionRequestService.getUserOptions(userOptionsLink);
        ParallelResourceProcessorResults<UserConfigItem> itemList = this.parallelProcessor.process(userOptionList);
        return itemList;
    }

    private Map<String, ExternalExtensionConfigValueView> createGlobalConfigMap(String globalConfigUrl) throws IntegrationException {
        List<ExternalExtensionConfigValueView> itemList = this.extensionConfigRequestService.getGlobalOptions(globalConfigUrl);
        Map<String, ExternalExtensionConfigValueView> itemMap = this.createConfigMap(itemList);
        return itemMap;
    }

    private Map<String, ExternalExtensionConfigValueView> createConfigMap(List<ExternalExtensionConfigValueView> itemList) {
        HashMap<String, ExternalExtensionConfigValueView> itemMap = new HashMap<String, ExternalExtensionConfigValueView>(itemList.size());
        for (ExternalExtensionConfigValueView item : itemList) {
            itemMap.put(item.name, item);
        }
        return itemMap;
    }
}

