/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.certificate;

import com.blackducksoftware.integration.exception.IntegrationCertificateException;
import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.certificate.CertTrustManager;
import com.blackducksoftware.integration.hub.proxy.OkAuthenticator;
import com.blackducksoftware.integration.hub.rest.TLSSocketFactory;
import com.blackducksoftware.integration.log.IntLogger;
import com.blackducksoftware.integration.util.proxy.ProxyUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;

public class CertificateHandler {
    public final IntLogger logger;
    public int timeout = 120;
    public String proxyHost;
    public int proxyPort;
    public String proxyNoHosts;
    public String proxyUsername;
    public String proxyPassword;
    private File javaHomeOverride;

    public CertificateHandler(IntLogger intLogger) {
        this.logger = intLogger;
    }

    public CertificateHandler(IntLogger intLogger, File javaHomeOverride) {
        this(intLogger);
        this.javaHomeOverride = javaHomeOverride;
    }

    public void retrieveAndImportHttpsCertificate(URL url) throws IntegrationException {
        if (url == null || !url.getProtocol().startsWith("https")) {
            return;
        }
        try {
            Certificate certificate = this.retrieveHttpsCertificateFromURL(url);
            if (certificate == null) {
                throw new IntegrationCertificateException(String.format("Could not retrieve the Certificate from %s", url));
            }
            this.importHttpsCertificate(url, certificate);
        }
        catch (IntegrationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IntegrationException(e.getMessage(), e);
        }
    }

    public Certificate retrieveHttpsCertificateFromURL(URL url) throws IntegrationException {
        if (url == null || !url.getProtocol().startsWith("https")) {
            return null;
        }
        this.logger.info(String.format("Retrieving the certificate from %s", url));
        Certificate certificate = null;
        try {
            OkHttpClient client = this.getOkHttpClient(url);
            HttpUrl.Builder urlBuilder = HttpUrl.get(url).newBuilder();
            HttpUrl httpUrl = urlBuilder.build();
            Request.Builder requestBuilder = new Request.Builder();
            Request request = requestBuilder.url(httpUrl).get().build();
            Response response = client.newCall(request).execute();
            List<Certificate> certificates = response.handshake().peerCertificates();
            certificate = certificates.get(0);
        }
        catch (Exception e) {
            throw new IntegrationException(e);
        }
        return certificate;
    }

    protected OkHttpClient getOkHttpClient(URL url) throws IntegrationException {
        CertTrustManager trustManager = new CertTrustManager();
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        clientBuilder.connectTimeout(this.timeout, TimeUnit.SECONDS);
        clientBuilder.writeTimeout(this.timeout, TimeUnit.SECONDS);
        clientBuilder.readTimeout(this.timeout, TimeUnit.SECONDS);
        if (this.shouldUseProxyForUrl(url)) {
            clientBuilder.proxy(this.getProxy(url));
            clientBuilder.proxyAuthenticator(new OkAuthenticator(this.proxyUsername, this.proxyPassword));
        }
        String version = System.getProperty("java.version");
        if (url.getProtocol().equalsIgnoreCase("https") && version.startsWith("1.7") || version.startsWith("1.6")) {
            try {
                clientBuilder.sslSocketFactory(new TLSSocketFactory(trustManager), trustManager);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new IntegrationException(e);
            }
        } else {
            clientBuilder.sslSocketFactory(this.systemDefaultSslSocketFactory(trustManager), trustManager);
        }
        return clientBuilder.build();
    }

    public Certificate retrieveHttpsCertificateFromTrustStore(URL url) throws IntegrationException {
        File trustStore = this.getTrustStore();
        String trustStorePath = trustStore.getAbsolutePath();
        this.logger.info(String.format("Removing the certificate from %s", trustStorePath));
        try {
            KeyStore keyStore = this.getKeyStore(trustStore);
            if (keyStore.containsAlias(url.getHost())) {
                return keyStore.getCertificate(url.getHost());
            }
        }
        catch (Exception e) {
            throw new IntegrationException(e);
        }
        return null;
    }

    public void importHttpsCertificate(URL url, Certificate certificate) throws IntegrationException {
        File trustStore = this.getTrustStore();
        String trustStorePath = trustStore.getAbsolutePath();
        this.logger.info(String.format("Importing the certificate from %s into keystore %s", url.getHost(), trustStorePath));
        try {
            KeyStore keyStore = this.getKeyStore(trustStore);
            keyStore.setCertificateEntry(url.getHost(), certificate);
            try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(trustStore));){
                keyStore.store(stream, this.getKeyStorePassword());
            }
        }
        catch (Exception e) {
            throw new IntegrationException(e);
        }
    }

    public void removeHttpsCertificate(URL url) throws IntegrationException {
        block14: {
            File trustStore = this.getTrustStore();
            String trustStorePath = trustStore.getAbsolutePath();
            this.logger.info(String.format("Removing the certificate from %s", trustStorePath));
            try {
                KeyStore keyStore = this.getKeyStore(trustStore);
                if (!keyStore.containsAlias(url.getHost())) break block14;
                keyStore.deleteEntry(url.getHost());
                try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(trustStore));){
                    keyStore.store(stream, this.getKeyStorePassword());
                }
            }
            catch (Exception e) {
                throw new IntegrationException(e);
            }
        }
    }

    public boolean isCertificateInTrustStore(URL url) throws IntegrationException {
        File trustStore = this.getTrustStore();
        if (!trustStore.isFile()) {
            return false;
        }
        String jssecacertsPath = trustStore.getAbsolutePath();
        this.logger.info(String.format("Checking for alias %s in keystore %s", url.getHost(), jssecacertsPath));
        try {
            KeyStore keyStore = this.getKeyStore(trustStore);
            return keyStore.containsAlias(url.getHost());
        }
        catch (Exception e) {
            throw new IntegrationException(e);
        }
    }

    public KeyStore getKeyStore(File trustStore) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (trustStore.isFile() && trustStore.length() > 0L) {
            KeyStore.PasswordProtection protection = new KeyStore.PasswordProtection(this.getKeyStorePassword());
            return KeyStore.Builder.newInstance(this.getTrustStoreType(), null, trustStore, protection).getKeyStore();
        }
        KeyStore keyStore = KeyStore.getInstance(this.getTrustStoreType());
        keyStore.load(null, null);
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(trustStore));){
            keyStore.store(stream, this.getKeyStorePassword());
        }
        return keyStore;
    }

    private String getTrustStoreType() {
        return System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType());
    }

    private char[] getKeyStorePassword() {
        return System.getProperty("javax.net.ssl.trustStorePassword", "changeit").toCharArray();
    }

    public File getTrustStore() {
        File trustStore;
        if (this.javaHomeOverride != null) {
            trustStore = this.resolveTrustStoreFile(this.javaHomeOverride);
        } else {
            trustStore = new File(System.getProperty("javax.net.ssl.trustStore", ""));
            if (!trustStore.isFile()) {
                File javaHome = new File(System.getProperty("java.home"));
                trustStore = this.resolveTrustStoreFile(javaHome);
            }
        }
        return trustStore;
    }

    private File resolveTrustStoreFile(File javaHome) {
        File trustStoreFile = new File(javaHome, "lib");
        trustStoreFile = new File(trustStoreFile, "security");
        if (!(trustStoreFile = new File(trustStoreFile, "jssecacerts")).isFile()) {
            trustStoreFile = new File(javaHome, "lib");
            trustStoreFile = new File(trustStoreFile, "security");
            trustStoreFile = new File(trustStoreFile, "cacerts");
        }
        return trustStoreFile;
    }

    private SSLSocketFactory systemDefaultSslSocketFactory(X509TrustManager trustManager) throws IntegrationException {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{trustManager}, null);
            return sslContext.getSocketFactory();
        }
        catch (GeneralSecurityException e) {
            throw new IntegrationException(e);
        }
    }

    private Proxy getProxy(URL hubUrl) {
        Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, this.proxyPort));
        return proxy;
    }

    private boolean shouldUseProxyForUrl(URL url) {
        if (StringUtils.isBlank(this.proxyHost) || this.proxyPort <= 0) {
            return false;
        }
        List<Pattern> ignoredProxyHostPatterns = ProxyUtil.getIgnoredProxyHostPatterns(this.proxyNoHosts);
        return !ProxyUtil.shouldIgnoreHost(url.getHost(), ignoredProxyHostPatterns);
    }
}

