/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.api.codelocation;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.exception.DoesNotExistException;
import com.blackducksoftware.integration.hub.model.enumeration.CodeLocationEnum;
import com.blackducksoftware.integration.hub.model.view.CodeLocationView;
import com.blackducksoftware.integration.hub.model.view.ProjectVersionView;
import com.blackducksoftware.integration.hub.request.HubPagedRequest;
import com.blackducksoftware.integration.hub.request.HubRequest;
import com.blackducksoftware.integration.hub.rest.RestConnection;
import com.blackducksoftware.integration.hub.service.HubService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;

public class CodeLocationService
extends HubService {
    private static final List<String> CODE_LOCATION_SEGMENTS = Arrays.asList("api", "codelocations");

    public CodeLocationService(RestConnection restConnection) {
        super(restConnection);
    }

    public List<CodeLocationView> getAllCodeLocations() throws IntegrationException {
        return this.getAllViewsFromApi("codelocations", CodeLocationView.class);
    }

    public List<CodeLocationView> getAllCodeLocationsForCodeLocationType(CodeLocationEnum codeLocationType) throws IntegrationException {
        HubPagedRequest hubPagedRequest = this.getHubRequestFactory().createPagedRequest(CODE_LOCATION_SEGMENTS).addQueryParameter("codeLocationType", codeLocationType.toString());
        List<CodeLocationView> allCodeLocations = this.getAllViews(hubPagedRequest, CodeLocationView.class);
        return allCodeLocations;
    }

    public List<CodeLocationView> getAllCodeLocationsForProjectVersion(ProjectVersionView version) throws IntegrationException {
        return this.getAllViewsFromLink(version, "codelocations", CodeLocationView.class);
    }

    public void unmapCodeLocations(List<CodeLocationView> codeLocationItems) throws IntegrationException {
        for (CodeLocationView codeLocationItem : codeLocationItems) {
            this.unmapCodeLocation(codeLocationItem);
        }
    }

    public void unmapCodeLocation(CodeLocationView codeLocationItem) throws IntegrationException {
        String codeLocationItemUrl = this.getHref(codeLocationItem);
        CodeLocationView requestCodeLocationView = this.createRequestCodeLocationView(codeLocationItem, "");
        this.updateCodeLocation(codeLocationItemUrl, this.getGson().toJson(requestCodeLocationView));
    }

    public void mapCodeLocation(CodeLocationView codeLocationItem, ProjectVersionView version) throws IntegrationException {
        this.mapCodeLocation(codeLocationItem, this.getHref(version));
    }

    public void mapCodeLocation(CodeLocationView codeLocationItem, String versionUrl) throws IntegrationException {
        String codeLocationItemUrl = this.getHref(codeLocationItem);
        CodeLocationView requestCodeLocationView = this.createRequestCodeLocationView(codeLocationItem, versionUrl);
        this.updateCodeLocation(codeLocationItemUrl, this.getGson().toJson(requestCodeLocationView));
    }

    public void updateCodeLocation(CodeLocationView codeLocationItem) throws IntegrationException {
        String codeLocationItemUrl = this.getHref(codeLocationItem);
        this.updateCodeLocation(codeLocationItemUrl, this.getGson().toJson(codeLocationItem));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCodeLocation(String codeLocationItemUrl, String codeLocationItemJson) throws IntegrationException {
        HubRequest request = this.getHubRequestFactory().createRequest(codeLocationItemUrl);
        try (Response response = null;){
            response = request.executePut(codeLocationItemJson);
        }
    }

    public void deleteCodeLocations(List<CodeLocationView> codeLocationItems) throws IntegrationException {
        for (CodeLocationView codeLocationItem : codeLocationItems) {
            this.deleteCodeLocation(codeLocationItem);
        }
    }

    public void deleteCodeLocation(CodeLocationView codeLocationItem) throws IntegrationException {
        String codeLocationItemUrl = this.getHref(codeLocationItem);
        this.deleteCodeLocation(codeLocationItemUrl);
    }

    public void deleteCodeLocation(String codeLocationItemUrl) throws IntegrationException {
        HubRequest request = this.getHubRequestFactory().createRequest(codeLocationItemUrl);
        request.executeDelete();
    }

    public CodeLocationView getCodeLocationByName(String codeLocationName) throws IntegrationException {
        if (StringUtils.isNotBlank(codeLocationName)) {
            HubPagedRequest hubPagedRequest = this.getHubRequestFactory().createPagedRequest(CODE_LOCATION_SEGMENTS);
            hubPagedRequest.q = "name:" + codeLocationName;
            List<CodeLocationView> codeLocations = this.getAllViews(hubPagedRequest, CodeLocationView.class);
            for (CodeLocationView codeLocation : codeLocations) {
                if (!codeLocationName.equals(codeLocation.name)) continue;
                return codeLocation;
            }
        }
        throw new DoesNotExistException("This Code Location does not exist. Code Location: " + codeLocationName);
    }

    public CodeLocationView getCodeLocationById(String codeLocationId) throws IntegrationException {
        ArrayList<String> segments = new ArrayList<String>(CODE_LOCATION_SEGMENTS);
        segments.add(codeLocationId);
        HubRequest request = this.getHubRequestFactory().createRequest(segments);
        return this.getView(request, CodeLocationView.class);
    }

    private CodeLocationView createRequestCodeLocationView(CodeLocationView codeLocationItem, String versionUrl) {
        CodeLocationView requestCodeLocationView = new CodeLocationView();
        requestCodeLocationView.createdAt = codeLocationItem.createdAt;
        requestCodeLocationView.mappedProjectVersion = versionUrl;
        requestCodeLocationView.name = codeLocationItem.name;
        requestCodeLocationView.type = codeLocationItem.type;
        requestCodeLocationView.updatedAt = codeLocationItem.updatedAt;
        requestCodeLocationView.url = codeLocationItem.url;
        return requestCodeLocationView;
    }
}

