/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub;

import com.blackducksoftware.integration.builder.AbstractBuilder;
import com.blackducksoftware.integration.encryption.PasswordEncrypter;
import com.blackducksoftware.integration.exception.EncryptionException;
import com.blackducksoftware.integration.hub.Credentials;
import com.blackducksoftware.integration.hub.validator.CredentialsValidator;
import com.blackducksoftware.integration.validator.AbstractValidator;
import org.apache.commons.lang3.StringUtils;

public class CredentialsBuilder
extends AbstractBuilder<Credentials> {
    private String username;
    private String password;
    private int passwordLength;

    @Override
    public Credentials buildObject() {
        Credentials creds = null;
        if (StringUtils.isNotBlank(this.password) && this.passwordLength == 0) {
            String encryptedPassword = null;
            try {
                encryptedPassword = PasswordEncrypter.encrypt(this.password);
            }
            catch (EncryptionException e) {
                throw new IllegalArgumentException(e);
            }
            creds = new Credentials(this.username, encryptedPassword, this.password.length());
        } else {
            creds = new Credentials(this.username, this.password, this.passwordLength);
        }
        return creds;
    }

    @Override
    public AbstractValidator createValidator() {
        CredentialsValidator validator = new CredentialsValidator();
        validator.setUsername(this.getUsername());
        validator.setPassword(this.getPassword());
        return validator;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPasswordLength() {
        return this.passwordLength;
    }

    public void setPasswordLength(int passwordLength) {
        this.passwordLength = passwordLength;
    }
}

