/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.validator;

import com.blackducksoftware.integration.hub.ApiKeyFieldEnum;
import com.blackducksoftware.integration.validator.AbstractValidator;
import com.blackducksoftware.integration.validator.ValidationResult;
import com.blackducksoftware.integration.validator.ValidationResultEnum;
import com.blackducksoftware.integration.validator.ValidationResults;
import org.apache.commons.lang3.StringUtils;

public class ApiKeyValidator
extends AbstractValidator {
    private String apiKey;

    @Override
    public ValidationResults assertValid() {
        ValidationResults result = new ValidationResults();
        this.validateCredentials(result);
        return result;
    }

    public void validateCredentials(ValidationResults result) {
        this.validateApiKey(result);
    }

    public void validateApiKey(ValidationResults result) {
        if (StringUtils.isBlank(this.apiKey)) {
            result.addResult(ApiKeyFieldEnum.API_KEY, new ValidationResult(ValidationResultEnum.ERROR, "No Hub API key was found."));
        }
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }
}

