/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.rest;

import com.blackducksoftware.integration.exception.EncryptionException;
import com.blackducksoftware.integration.hub.Credentials;
import com.blackducksoftware.integration.hub.proxy.ProxyInfo;
import com.blackducksoftware.integration.hub.rest.AbstractRestConnectionBuilder;
import com.blackducksoftware.integration.hub.rest.CredentialsRestConnection;
import com.blackducksoftware.integration.hub.validator.CredentialsRestConnectionValidator;
import com.blackducksoftware.integration.validator.AbstractValidator;

public class CredentialsRestConnectionBuilder
extends AbstractRestConnectionBuilder<CredentialsRestConnection> {
    private String username;
    private String password;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void applyCredentials(Credentials credentials) {
        try {
            this.setUsername(credentials.getUsername());
            this.setPassword(credentials.getDecryptedPassword());
        }
        catch (EncryptionException | IllegalArgumentException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public AbstractValidator createValidator() {
        CredentialsRestConnectionValidator validator = new CredentialsRestConnectionValidator();
        validator.setBaseUrl(this.getBaseUrl());
        validator.setTimeout(this.getTimeout());
        validator.setUsername(this.getUsername());
        validator.setPassword(this.getPassword());
        validator.setProxyHost(this.getProxyHost());
        validator.setProxyPort(this.getProxyPort());
        validator.setProxyUsername(this.getProxyUsername());
        validator.setProxyPassword(this.getProxyPassword());
        validator.setProxyIgnoreHosts(this.getProxyIgnoreHosts());
        validator.setLogger(this.getLogger());
        validator.setCommonRequestHeaders(this.getCommonRequestHeaders());
        return validator;
    }

    @Override
    public CredentialsRestConnection createConnection(ProxyInfo proxyInfo) {
        CredentialsRestConnection connection = new CredentialsRestConnection(this.getLogger(), this.getBaseConnectionUrl(), this.getUsername(), this.getPassword(), this.getTimeout(), proxyInfo);
        return connection;
    }
}

