/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.request;

import com.blackducksoftware.integration.hub.request.HubPagedRequest;
import com.blackducksoftware.integration.hub.request.HubRequest;
import com.blackducksoftware.integration.hub.rest.RestConnection;
import java.util.List;

public class HubRequestFactory {
    private final RestConnection restConnection;

    public HubRequestFactory(RestConnection restConnection) {
        this.restConnection = restConnection;
    }

    public HubPagedRequest createPagedRequest(List<String> urlSegments) {
        HubPagedRequest hubPagedRequest = new HubPagedRequest(this.restConnection);
        hubPagedRequest.limit = 100;
        hubPagedRequest.addUrlSegments(urlSegments);
        return hubPagedRequest;
    }

    public HubPagedRequest createPagedRequest(int itemsPerPage, List<String> urlSegments) {
        HubPagedRequest hubPagedRequest = new HubPagedRequest(this.restConnection);
        hubPagedRequest.limit = itemsPerPage;
        hubPagedRequest.addUrlSegments(urlSegments);
        return hubPagedRequest;
    }

    public HubPagedRequest createPagedRequest(List<String> urlSegments, String q) {
        HubPagedRequest hubPagedRequest = new HubPagedRequest(this.restConnection);
        hubPagedRequest.limit = 100;
        hubPagedRequest.addUrlSegments(urlSegments);
        hubPagedRequest.q = q;
        return hubPagedRequest;
    }

    public HubPagedRequest createPagedRequest(int itemsPerPage, List<String> urlSegments, String q) {
        HubPagedRequest hubPagedRequest = new HubPagedRequest(this.restConnection);
        hubPagedRequest.limit = itemsPerPage;
        hubPagedRequest.addUrlSegments(urlSegments);
        hubPagedRequest.q = q;
        return hubPagedRequest;
    }

    public HubPagedRequest createPagedRequest(String url) {
        HubPagedRequest hubPagedRequest = new HubPagedRequest(this.restConnection);
        hubPagedRequest.limit = 100;
        hubPagedRequest.url = url;
        return hubPagedRequest;
    }

    public HubPagedRequest createPagedRequest(int itemsPerPage, String url) {
        HubPagedRequest hubPagedRequest = new HubPagedRequest(this.restConnection);
        hubPagedRequest.limit = itemsPerPage;
        hubPagedRequest.url = url;
        return hubPagedRequest;
    }

    public HubPagedRequest createPagedRequest(String url, String q) {
        HubPagedRequest hubPagedRequest = new HubPagedRequest(this.restConnection);
        hubPagedRequest.limit = 100;
        hubPagedRequest.url = url;
        hubPagedRequest.q = q;
        return hubPagedRequest;
    }

    public HubPagedRequest createPagedRequest(int itemsPerPage, String url, String q) {
        HubPagedRequest hubPagedRequest = new HubPagedRequest(this.restConnection);
        hubPagedRequest.limit = itemsPerPage;
        hubPagedRequest.url = url;
        hubPagedRequest.q = q;
        return hubPagedRequest;
    }

    public HubRequest createRequest(List<String> urlSegments) {
        HubRequest hubRequest = new HubRequest(this.restConnection);
        hubRequest.addUrlSegments(urlSegments);
        return hubRequest;
    }

    public HubRequest createRequest(String url) {
        HubRequest hubRequest = new HubRequest(this.restConnection);
        hubRequest.url = url;
        return hubRequest;
    }

    public HubRequest createRequest() {
        return new HubRequest(this.restConnection);
    }
}

