/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.dataservice.project;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.api.project.ProjectAssignmentService;
import com.blackducksoftware.integration.hub.api.project.ProjectService;
import com.blackducksoftware.integration.hub.api.project.version.ProjectVersionService;
import com.blackducksoftware.integration.hub.dataservice.project.ProjectVersionWrapper;
import com.blackducksoftware.integration.hub.exception.DoesNotExistException;
import com.blackducksoftware.integration.hub.model.request.ProjectRequest;
import com.blackducksoftware.integration.hub.model.view.AssignedGroupView;
import com.blackducksoftware.integration.hub.model.view.AssignedUserView;
import com.blackducksoftware.integration.hub.model.view.ProjectVersionView;
import com.blackducksoftware.integration.hub.model.view.ProjectView;
import com.blackducksoftware.integration.hub.model.view.UserGroupView;
import com.blackducksoftware.integration.hub.model.view.UserView;
import com.blackducksoftware.integration.hub.request.builder.ProjectRequestBuilder;
import com.blackducksoftware.integration.hub.rest.RestConnection;
import com.blackducksoftware.integration.hub.service.HubService;
import com.blackducksoftware.integration.log.IntLogger;
import java.util.ArrayList;
import java.util.List;

public class ProjectDataService
extends HubService {
    private final IntLogger logger;
    private final ProjectService projectRequestService;
    private final ProjectVersionService projectVersionRequestService;
    private final ProjectAssignmentService projectAssignmentRequestService;

    public ProjectDataService(RestConnection restConnection, ProjectService projectRequestService, ProjectVersionService projectVersionRequestService, ProjectAssignmentService projectAssignmentRequestService) {
        super(restConnection);
        this.logger = restConnection.logger;
        this.projectRequestService = projectRequestService;
        this.projectVersionRequestService = projectVersionRequestService;
        this.projectAssignmentRequestService = projectAssignmentRequestService;
    }

    public ProjectVersionWrapper getProjectVersion(String projectName, String projectVersionName) throws IntegrationException {
        ProjectView projectView = this.projectRequestService.getProjectByName(projectName);
        ProjectVersionView projectVersionView = this.projectVersionRequestService.getProjectVersion(projectView, projectVersionName);
        ProjectVersionWrapper projectVersionWrapper = new ProjectVersionWrapper();
        projectVersionWrapper.setProjectView(projectView);
        projectVersionWrapper.setProjectVersionView(projectVersionView);
        return projectVersionWrapper;
    }

    public ProjectVersionWrapper getProjectVersionAndCreateIfNeeded(String projectName, String projectVersionName) throws IntegrationException {
        ProjectRequestBuilder projectRequestBuilder = new ProjectRequestBuilder();
        projectRequestBuilder.setProjectName(projectName);
        projectRequestBuilder.setVersionName(projectVersionName);
        ProjectRequest projectRequest = (ProjectRequest)projectRequestBuilder.build();
        return this.getProjectVersionAndCreateIfNeeded(projectRequest);
    }

    public ProjectVersionWrapper getProjectVersionAndCreateIfNeeded(ProjectRequest projectRequest) throws IntegrationException {
        ProjectView project = null;
        ProjectVersionView projectVersion = null;
        try {
            project = this.projectRequestService.getProjectByName(projectRequest.getName());
        }
        catch (DoesNotExistException e) {
            String projectURL = this.projectRequestService.createHubProject(projectRequest);
            project = this.projectRequestService.getView(projectURL, ProjectView.class);
        }
        try {
            projectVersion = this.projectVersionRequestService.getProjectVersion(project, projectRequest.getVersionRequest().getVersionName());
        }
        catch (DoesNotExistException e) {
            String versionURL = this.projectVersionRequestService.createHubVersion(project, projectRequest.getVersionRequest());
            projectVersion = this.projectVersionRequestService.getView(versionURL, ProjectVersionView.class);
        }
        ProjectVersionWrapper projectVersionWrapper = new ProjectVersionWrapper();
        projectVersionWrapper.setProjectView(project);
        projectVersionWrapper.setProjectVersionView(projectVersion);
        return projectVersionWrapper;
    }

    public List<AssignedUserView> getAssignedUsersToProject(String projectName) throws IntegrationException {
        ProjectView project = this.projectRequestService.getProjectByName(projectName);
        return this.getAssignedUsersToProject(project);
    }

    public List<AssignedUserView> getAssignedUsersToProject(ProjectView project) throws IntegrationException {
        List<AssignedUserView> assignedUsers = this.projectAssignmentRequestService.getProjectUsers(project);
        return assignedUsers;
    }

    public List<UserView> getUsersForProject(String projectName) throws IntegrationException {
        ProjectView project = this.projectRequestService.getProjectByName(projectName);
        return this.getUsersForProject(project);
    }

    public List<UserView> getUsersForProject(ProjectView project) throws IntegrationException {
        this.logger.debug("Attempting to get the assigned users for Project: " + project.name);
        List<AssignedUserView> assignedUsers = this.projectAssignmentRequestService.getProjectUsers(project);
        ArrayList<UserView> resolvedUserViews = new ArrayList<UserView>();
        for (AssignedUserView assigned : assignedUsers) {
            UserView userView = this.getView(assigned.userUrl, UserView.class);
            if (userView == null) continue;
            resolvedUserViews.add(userView);
        }
        return resolvedUserViews;
    }

    public List<AssignedGroupView> getAssignedGroupsToProject(String projectName) throws IntegrationException {
        ProjectView project = this.projectRequestService.getProjectByName(projectName);
        return this.getAssignedGroupsToProject(project);
    }

    public List<AssignedGroupView> getAssignedGroupsToProject(ProjectView project) throws IntegrationException {
        List<AssignedGroupView> assignedGroups = this.projectAssignmentRequestService.getProjectGroups(project);
        return assignedGroups;
    }

    public List<UserGroupView> getGroupsForProject(String projectName) throws IntegrationException {
        ProjectView project = this.projectRequestService.getProjectByName(projectName);
        return this.getGroupsForProject(project);
    }

    public List<UserGroupView> getGroupsForProject(ProjectView project) throws IntegrationException {
        this.logger.debug("Attempting to get the assigned users for Project: " + project.name);
        List<AssignedGroupView> assignedGroups = this.projectAssignmentRequestService.getProjectGroups(project);
        ArrayList<UserGroupView> resolvedGroupViews = new ArrayList<UserGroupView>();
        for (AssignedGroupView assigned : assignedGroups) {
            UserGroupView groupView = this.getView(assigned.groupUrl, UserGroupView.class);
            if (groupView == null) continue;
            resolvedGroupViews.add(groupView);
        }
        return resolvedGroupViews;
    }
}

