/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.dataservice.notification.model;

import com.blackducksoftware.integration.hub.dataservice.model.ProjectVersionModel;
import com.blackducksoftware.integration.hub.model.view.ComponentVersionView;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.RecursiveToStringStyle;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

public class NotificationContentItem
implements Comparable<NotificationContentItem> {
    private final ProjectVersionModel projectVersion;
    private final String componentName;
    private final ComponentVersionView componentVersion;
    private final String componentVersionUrl;
    private String componentIssueLink;
    public final Date createdAt;

    public NotificationContentItem(Date createdAt, ProjectVersionModel projectVersion, String componentName, ComponentVersionView componentVersion, String componentVersionUrl, String componentIssueUrl) {
        this.createdAt = createdAt;
        this.projectVersion = projectVersion;
        this.componentName = componentName;
        this.componentVersion = componentVersion;
        this.componentVersionUrl = componentVersionUrl;
        this.componentIssueLink = componentIssueUrl;
    }

    public ProjectVersionModel getProjectVersion() {
        return this.projectVersion;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public ComponentVersionView getComponentVersion() {
        return this.componentVersion;
    }

    public String getComponentVersionUrl() {
        return this.componentVersionUrl;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getComponentIssueLink() {
        return this.componentIssueLink;
    }

    public void setComponentIssueLink(String componentIssueLink) {
        this.componentIssueLink = componentIssueLink;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString(this, RecursiveToStringStyle.JSON_STYLE);
    }

    @Override
    public int compareTo(NotificationContentItem o) {
        if (this.equals(o)) {
            return 0;
        }
        int createdAtComparison = this.getCreatedAt().compareTo(o.getCreatedAt());
        if (createdAtComparison != 0) {
            return createdAtComparison;
        }
        String thisProjectVersionString = StringUtils.join(this.getProjectVersion().getProjectName(), this.getProjectVersion().getProjectVersionName(), this.getComponentName(), this.getComponentVersionName(this.getComponentVersion()));
        String otherProjectVersionString = StringUtils.join(o.getProjectVersion().getProjectName(), o.getProjectVersion().getProjectVersionName(), o.getComponentName(), this.getComponentVersionName(o.getComponentVersion()));
        return thisProjectVersionString.compareTo(otherProjectVersionString);
    }

    private String getComponentVersionName(ComponentVersionView componentVersion) {
        if (componentVersion == null) {
            return "";
        }
        return componentVersion.versionName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.componentIssueLink == null ? 0 : this.componentIssueLink.hashCode());
        result = 31 * result + (this.componentName == null ? 0 : this.componentName.hashCode());
        result = 31 * result + (this.componentVersion == null ? 0 : this.componentVersion.hashCode());
        result = 31 * result + (this.componentVersionUrl == null ? 0 : this.componentVersionUrl.hashCode());
        result = 31 * result + (this.createdAt == null ? 0 : this.createdAt.hashCode());
        result = 31 * result + (this.projectVersion == null ? 0 : this.projectVersion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NotificationContentItem other = (NotificationContentItem)obj;
        if (this.componentIssueLink == null ? other.componentIssueLink != null : !this.componentIssueLink.equals(other.componentIssueLink)) {
            return false;
        }
        if (this.componentName == null ? other.componentName != null : !this.componentName.equals(other.componentName)) {
            return false;
        }
        if (this.componentVersion == null ? other.componentVersion != null : !this.componentVersion.equals(other.componentVersion)) {
            return false;
        }
        if (this.componentVersionUrl == null ? other.componentVersionUrl != null : !this.componentVersionUrl.equals(other.componentVersionUrl)) {
            return false;
        }
        if (this.createdAt == null ? other.createdAt != null : !this.createdAt.equals(other.createdAt)) {
            return false;
        }
        return !(this.projectVersion == null ? other.projectVersion != null : !this.projectVersion.equals(other.projectVersion));
    }
}

