/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.api.report;

import com.blackducksoftware.integration.hub.model.enumeration.ProjectVersionDistributionEnum;
import com.blackducksoftware.integration.hub.model.enumeration.ProjectVersionPhaseEnum;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.RecursiveToStringStyle;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.joda.time.DateTime;

public class DetailedReleaseSummary {
    private static final Map<ProjectVersionDistributionEnum, String> distributionDisplayStringsMap = new HashMap<ProjectVersionDistributionEnum, String>();
    private static final Map<ProjectVersionPhaseEnum, String> phaseDisplayStringsMap = new HashMap<ProjectVersionPhaseEnum, String>();
    private final String projectId;
    private final String versionId;
    private final String projectName;
    private final String version;
    private final String versionComments;
    private final String nickname;
    private final String releasedOn;
    private final String phase;
    private final String distribution;
    private final URLProvider uiUrlGenerator;

    public DetailedReleaseSummary(String projectId, String versionId, String projectName, String version, String versionComments, String nickname, String releasedOn, String phase, String distribution, URLProvider uiUrlGenerator) {
        this.projectId = projectId;
        this.versionId = versionId;
        this.projectName = projectName;
        this.version = version;
        this.versionComments = versionComments;
        this.nickname = nickname;
        this.releasedOn = releasedOn;
        this.phase = phase;
        this.distribution = distribution;
        this.uiUrlGenerator = uiUrlGenerator;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public UUID getProjectUUId() {
        if (StringUtils.isBlank(this.projectId)) {
            return null;
        }
        try {
            return UUID.fromString(this.projectId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public UUID getVersionUUId() {
        if (StringUtils.isBlank(this.versionId)) {
            return null;
        }
        try {
            return UUID.fromString(this.versionId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getVersionComments() {
        return this.versionComments;
    }

    public String getNickname() {
        return this.nickname;
    }

    public String getReleasedOn() {
        return this.releasedOn;
    }

    public String getPhase() {
        return this.phase;
    }

    public String getDistribution() {
        return this.distribution;
    }

    public String getPhaseDisplayValue() {
        if (StringUtils.isBlank(this.phase)) {
            return null;
        }
        String fixedPhaseString = this.phase.replaceAll("\\s", "").toUpperCase();
        for (ProjectVersionPhaseEnum type : ProjectVersionPhaseEnum.values()) {
            if (!type.toString().equals(fixedPhaseString)) continue;
            return phaseDisplayStringsMap.get((Object)type);
        }
        return "Unknown Phase";
    }

    public String getDistributionDisplayValue() {
        if (StringUtils.isBlank(this.distribution)) {
            return null;
        }
        String fixedDistributionString = this.distribution.replaceAll("\\s", "").toUpperCase();
        for (ProjectVersionDistributionEnum type : ProjectVersionDistributionEnum.values()) {
            if (!type.toString().equals(fixedDistributionString)) continue;
            return distributionDisplayStringsMap.get((Object)type);
        }
        return "Unknown Distribution";
    }

    public DateTime getReleasedOnTime() {
        if (StringUtils.isBlank(this.releasedOn)) {
            return null;
        }
        try {
            return new DateTime((Object)this.releasedOn);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public URLProvider getUiUrlGenerator() {
        return this.uiUrlGenerator;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.distribution == null ? 0 : this.distribution.hashCode());
        result = 31 * result + (this.nickname == null ? 0 : this.nickname.hashCode());
        result = 31 * result + (this.phase == null ? 0 : this.phase.hashCode());
        result = 31 * result + (this.projectId == null ? 0 : this.projectId.hashCode());
        result = 31 * result + (this.projectName == null ? 0 : this.projectName.hashCode());
        result = 31 * result + (this.releasedOn == null ? 0 : this.releasedOn.hashCode());
        result = 31 * result + (this.uiUrlGenerator == null ? 0 : this.uiUrlGenerator.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + (this.versionComments == null ? 0 : this.versionComments.hashCode());
        result = 31 * result + (this.versionId == null ? 0 : this.versionId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetailedReleaseSummary)) {
            return false;
        }
        DetailedReleaseSummary other = (DetailedReleaseSummary)obj;
        if (this.distribution == null ? other.distribution != null : !this.distribution.equals(other.distribution)) {
            return false;
        }
        if (this.nickname == null ? other.nickname != null : !this.nickname.equals(other.nickname)) {
            return false;
        }
        if (this.phase == null ? other.phase != null : !this.phase.equals(other.phase)) {
            return false;
        }
        if (this.projectId == null ? other.projectId != null : !this.projectId.equals(other.projectId)) {
            return false;
        }
        if (this.projectName == null ? other.projectName != null : !this.projectName.equals(other.projectName)) {
            return false;
        }
        if (this.releasedOn == null ? other.releasedOn != null : !this.releasedOn.equals(other.releasedOn)) {
            return false;
        }
        if (this.uiUrlGenerator == null ? other.uiUrlGenerator != null : !this.uiUrlGenerator.equals(other.uiUrlGenerator)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        if (this.versionComments == null ? other.versionComments != null : !this.versionComments.equals(other.versionComments)) {
            return false;
        }
        return !(this.versionId == null ? other.versionId != null : !this.versionId.equals(other.versionId));
    }

    public String toString() {
        return ReflectionToStringBuilder.toString(this, RecursiveToStringStyle.JSON_STYLE);
    }

    static {
        distributionDisplayStringsMap.put(ProjectVersionDistributionEnum.EXTERNAL, "External");
        distributionDisplayStringsMap.put(ProjectVersionDistributionEnum.SAAS, "SaaS");
        distributionDisplayStringsMap.put(ProjectVersionDistributionEnum.INTERNAL, "Internal");
        distributionDisplayStringsMap.put(ProjectVersionDistributionEnum.OPENSOURCE, "Open Source");
        phaseDisplayStringsMap.put(ProjectVersionPhaseEnum.ARCHIVED, "Archived");
        phaseDisplayStringsMap.put(ProjectVersionPhaseEnum.DEPRECATED, "Deprecated");
        phaseDisplayStringsMap.put(ProjectVersionPhaseEnum.DEVELOPMENT, "In Development");
        phaseDisplayStringsMap.put(ProjectVersionPhaseEnum.PLANNING, "In Planning");
        phaseDisplayStringsMap.put(ProjectVersionPhaseEnum.RELEASED, "Released");
    }

    public static class URLProvider {
        private final String baseUrl;

        public URLProvider(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.baseUrl == null ? 0 : this.baseUrl.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof URLProvider)) {
                return false;
            }
            URLProvider other = (URLProvider)obj;
            return !(this.baseUrl == null ? other.baseUrl != null : !this.baseUrl.equals(other.baseUrl));
        }

        public String toString() {
            return ReflectionToStringBuilder.toString(this, RecursiveToStringStyle.JSON_STYLE);
        }
    }
}

