/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.api.notification;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.model.view.NotificationView;
import com.blackducksoftware.integration.hub.model.view.PolicyOverrideNotificationView;
import com.blackducksoftware.integration.hub.model.view.RuleViolationClearedNotificationView;
import com.blackducksoftware.integration.hub.model.view.RuleViolationNotificationView;
import com.blackducksoftware.integration.hub.model.view.UserView;
import com.blackducksoftware.integration.hub.model.view.VulnerabilityNotificationView;
import com.blackducksoftware.integration.hub.request.HubPagedRequest;
import com.blackducksoftware.integration.hub.request.HubRequestFactory;
import com.blackducksoftware.integration.hub.rest.RestConnection;
import com.blackducksoftware.integration.hub.service.HubService;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.Closeable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;

public class NotificationService
extends HubService {
    private static final List<String> NOTIFICATIONS_SEGMENTS = Arrays.asList("api", "notifications");
    private final Map<String, Class<? extends NotificationView>> typeMap = new HashMap<String, Class<? extends NotificationView>>();
    private final HubRequestFactory hubRequestFactory;
    private final JsonParser jsonParser;

    public NotificationService(RestConnection restConnection) {
        super(restConnection);
        this.hubRequestFactory = new HubRequestFactory(restConnection);
        this.jsonParser = restConnection.jsonParser;
        this.typeMap.put("VULNERABILITY", VulnerabilityNotificationView.class);
        this.typeMap.put("RULE_VIOLATION", RuleViolationNotificationView.class);
        this.typeMap.put("POLICY_OVERRIDE", PolicyOverrideNotificationView.class);
        this.typeMap.put("RULE_VIOLATION_CLEARED", RuleViolationClearedNotificationView.class);
    }

    public List<NotificationView> getAllNotifications(Date startDate, Date endDate) throws IntegrationException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String startDateString = sdf.format(startDate);
        String endDateString = sdf.format(endDate);
        HubPagedRequest hubPagedRequest = this.hubRequestFactory.createPagedRequest(100, NOTIFICATIONS_SEGMENTS);
        hubPagedRequest.addQueryParameter("startDate", startDateString);
        hubPagedRequest.addQueryParameter("endDate", endDateString);
        List<NotificationView> allNotificationItems = this.getAllItems(hubPagedRequest);
        return allNotificationItems;
    }

    public List<NotificationView> getUserNotifications(Date startDate, Date endDate, UserView user) throws IntegrationException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String startDateString = sdf.format(startDate);
        String endDateString = sdf.format(endDate);
        String url = this.getFirstLink(user, "notifications");
        HubPagedRequest hubPagedRequest = this.hubRequestFactory.createPagedRequest(100, url);
        hubPagedRequest.addQueryParameter("startDate", startDateString);
        hubPagedRequest.addQueryParameter("endDate", endDateString);
        List<NotificationView> allNotificationItems = this.getAllItems(hubPagedRequest);
        return allNotificationItems;
    }

    public List<NotificationView> getItems(JsonObject jsonObject) throws IntegrationException {
        LinkedList<NotificationView> itemList = new LinkedList<NotificationView>();
        JsonElement itemsElement = jsonObject.get("items");
        JsonArray itemsArray = itemsElement.getAsJsonArray();
        for (JsonElement element : itemsArray) {
            String type = element.getAsJsonObject().get("type").getAsString();
            Class<NotificationView> notificationClass = NotificationView.class;
            if (this.typeMap.containsKey(type)) {
                notificationClass = this.typeMap.get(type);
            }
            NotificationView item = this.getViewAs(element, notificationClass);
            itemList.add(item);
        }
        return itemList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NotificationView> getItems(HubPagedRequest hubPagedRequest) throws IntegrationException {
        Response response = null;
        try {
            response = hubPagedRequest.executeGet();
            String jsonResponse = this.readResponseString(response);
            JsonObject jsonObject = this.jsonParser.parse(jsonResponse).getAsJsonObject();
            List<NotificationView> list = this.getItems(jsonObject);
            return list;
        }
        finally {
            IOUtils.closeQuietly((Closeable)response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NotificationView> getAllItems(HubPagedRequest hubPagedRequest) throws IntegrationException {
        LinkedList<NotificationView> allItems = new LinkedList<NotificationView>();
        int totalCount = 0;
        int currentOffset = hubPagedRequest.offset;
        Response response = null;
        try {
            response = hubPagedRequest.executeGet();
            String jsonResponse = this.readResponseString(response);
            JsonObject jsonObject = this.jsonParser.parse(jsonResponse).getAsJsonObject();
            totalCount = jsonObject.get("totalCount").getAsInt();
            allItems.addAll(this.getItems(jsonObject));
            while (currentOffset < totalCount) {
                hubPagedRequest.offset = currentOffset += hubPagedRequest.limit;
                allItems.addAll(this.getItems(hubPagedRequest));
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)response);
        }
        return allItems;
    }
}

