/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.api.nonpublic;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.model.response.VersionComparison;
import com.blackducksoftware.integration.hub.request.HubRequest;
import com.blackducksoftware.integration.hub.rest.RestConnection;
import com.blackducksoftware.integration.hub.service.HubService;
import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;

public class HubVersionService
extends HubService {
    private static final List<String> CURRENT_VERSION_SEGMENTS = Arrays.asList("api", "v1", "current-version");
    private static final List<String> CURRENT_VERSION_COMPARISON_SEGMENTS = Arrays.asList("api", "v1", "current-version-comparison");

    public HubVersionService(RestConnection restConnection) {
        super(restConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHubVersion() throws IntegrationException {
        HubRequest request = this.getHubRequestFactory().createRequest(CURRENT_VERSION_SEGMENTS);
        Response response = null;
        try {
            String hubVersion;
            response = request.executeGet();
            String hubVersionWithPossibleSurroundingQuotes = this.readResponseString(response);
            String string = hubVersion = hubVersionWithPossibleSurroundingQuotes.replace("\"", "");
            return string;
        }
        finally {
            IOUtils.closeQuietly((Closeable)response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionComparison getHubVersionComparison(String consumerVersion) throws IntegrationException {
        HubRequest hubVersionRequest = this.getHubRequestFactory().createRequest(CURRENT_VERSION_COMPARISON_SEGMENTS).addQueryParameter("version", consumerVersion);
        Response response = null;
        try {
            VersionComparison versionComparison;
            response = hubVersionRequest.executeGet();
            String jsonResponse = this.readResponseString(response);
            VersionComparison versionComparison2 = versionComparison = this.getGson().fromJson(jsonResponse, VersionComparison.class);
            return versionComparison2;
        }
        finally {
            IOUtils.closeQuietly((Closeable)response);
        }
    }

    public boolean isConsumerVersionLessThanOrEqualToServerVersion(String consumerVersion) throws IntegrationException {
        VersionComparison versionComparison = this.getHubVersionComparison(consumerVersion);
        return versionComparison.numericResult <= 0;
    }
}

