#
# Copyright (c) 2018. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import re
from blackduck.hub_services_helper import HubServicesHelper
from com.blackducksoftware.integration.hub.exception import DoesNotExistException

if not blackduckServer:
    raise Exception("Blackduck server ID must be provided")


def normalize_key(key):
    return re.search('(vulnerability|operational|license)(Risk(High|Low|Medium|None)Count)', key).group(3)

hub_services_helper = HubServicesHelper(params=blackduckServer)

try:
    risk_profile_view, _, version_view = hub_services_helper.get_risk_profile(projectName, version)
    riskTypeFields = {'Security Risks': 'vulnerability', 'Operational Risks': 'operational', 'License Risks': 'license'}
    counts = risk_profile_view.categories.__getattribute__(riskTypeFields[riskType])
    data = {'riskProfile': {"High": counts.highCount,
                            "Low": counts.lowCount,
                            "Medium": counts.mediumCount,
                            "None": counts.okCount},
            'projectName': projectName, 'projectVersion': version,
            'projectVersionURL': version_view.meta.href, 'riskType': riskType, 'last_updated': risk_profile_view.bomLastUpdatedAt}
except DoesNotExistException as exception:
    data = {'error': exception.message}

