/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.phonehome;

import com.blackducksoftware.integration.phonehome.enums.PhoneHomeRequestFieldEnum;
import com.blackducksoftware.integration.validator.AbstractValidator;
import com.blackducksoftware.integration.validator.ValidationResult;
import com.blackducksoftware.integration.validator.ValidationResultEnum;
import com.blackducksoftware.integration.validator.ValidationResults;
import org.apache.commons.lang3.StringUtils;

public class PhoneHomeRequestBodyValidator
extends AbstractValidator {
    private String registrationId;
    private String hostName;
    private String blackDuckName;
    private String blackDuckVersion;
    private String thirdPartyName;
    private String thirdPartyVersion;
    private String pluginVersion;
    private String source;

    @Override
    public ValidationResults assertValid() {
        ValidationResults result = new ValidationResults();
        this.validateHubServerIdentifier(result);
        this.validateBlackDuckProductInfo(result);
        this.validateThirdPartyProductInfo(result);
        this.validateIntegrationInfo(result);
        this.validateSource(result);
        return result;
    }

    public void validateHubServerIdentifier(ValidationResults result) {
        if (StringUtils.isBlank(this.registrationId) && StringUtils.isBlank(this.hostName)) {
            result.addResult(PhoneHomeRequestFieldEnum.REGID, new ValidationResult(ValidationResultEnum.ERROR, "No Hub server identifier was found."));
        }
    }

    public void validateBlackDuckProductInfo(ValidationResults result) {
        if (this.blackDuckName == null || StringUtils.isBlank(this.blackDuckName)) {
            result.addResult(PhoneHomeRequestFieldEnum.BLACKDUCKNAME, new ValidationResult(ValidationResultEnum.ERROR, "No Black Duck product name was found."));
        } else if (StringUtils.isBlank(this.blackDuckVersion)) {
            result.addResult(PhoneHomeRequestFieldEnum.BLACKDUCKVERSION, new ValidationResult(ValidationResultEnum.ERROR, String.format("No version of %s was found.", this.blackDuckName)));
        }
    }

    public void validateThirdPartyProductInfo(ValidationResults result) {
        if (this.thirdPartyName == null || StringUtils.isBlank(this.thirdPartyName)) {
            result.addResult(PhoneHomeRequestFieldEnum.THIRDPARTYNAME, new ValidationResult(ValidationResultEnum.ERROR, "No third party name was found."));
        } else if (StringUtils.isBlank(this.thirdPartyVersion)) {
            result.addResult(PhoneHomeRequestFieldEnum.THIRDPARTYVERSION, new ValidationResult(ValidationResultEnum.ERROR, String.format("No version of %s was found.", this.thirdPartyName)));
        }
    }

    public void validateIntegrationInfo(ValidationResults result) {
        if (StringUtils.isBlank(this.pluginVersion)) {
            result.addResult(PhoneHomeRequestFieldEnum.PLUGINVERSION, new ValidationResult(ValidationResultEnum.ERROR, "No plugin version was found."));
        }
    }

    public void validateSource(ValidationResults result) {
        if (this.source == null || StringUtils.isBlank(this.source)) {
            result.addResult(PhoneHomeRequestFieldEnum.PLUGINVERSION, new ValidationResult(ValidationResultEnum.ERROR, "No source was found."));
        }
    }

    public void setRegistrationId(String registrationId) {
        this.registrationId = registrationId;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setBlackDuckName(String blackDuckName) {
        this.blackDuckName = blackDuckName;
    }

    public void setBlackDuckVersion(String blackDuckVersion) {
        this.blackDuckVersion = blackDuckVersion;
    }

    public void setThirdPartyName(String thirdPartyName) {
        this.thirdPartyName = thirdPartyName;
    }

    public void setThirdPartyVersion(String thirdPartyVersion) {
        this.thirdPartyVersion = thirdPartyVersion;
    }

    public void setPluginVersion(String pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

    public void setSource(String source) {
        this.source = source;
    }
}

