/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.service;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.api.view.MetaHandler;
import com.blackducksoftware.integration.hub.exception.HubIntegrationException;
import com.blackducksoftware.integration.hub.model.HubView;
import com.blackducksoftware.integration.hub.request.HubPagedRequest;
import com.blackducksoftware.integration.hub.request.HubRequestFactory;
import com.blackducksoftware.integration.hub.service.HubViewsTransformer;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class AllHubViewsTransformer {
    private final HubViewsTransformer hubViewsTransformer;
    private final HubRequestFactory hubRequestFactory;
    private final MetaHandler metaHandler;
    private final JsonParser jsonParser;

    public AllHubViewsTransformer(HubViewsTransformer hubViewsTransformer, HubRequestFactory hubRequestFactory, MetaHandler metaHandler, JsonParser jsonParser) {
        this.hubViewsTransformer = hubViewsTransformer;
        this.hubRequestFactory = hubRequestFactory;
        this.metaHandler = metaHandler;
        this.jsonParser = jsonParser;
    }

    public <T extends HubView> List<T> getAllViewsFromApi(String apiSegment, Class<T> clazz) throws IntegrationException {
        return this.getAllViewsFromApi(apiSegment, clazz, 100, null);
    }

    public <T extends HubView> List<T> getAllViewsFromApi(String apiSegment, Class<T> clazz, String mediaType) throws IntegrationException {
        return this.getAllViewsFromApi(apiSegment, clazz, 100, mediaType);
    }

    public <T extends HubView> List<T> getAllViewsFromApi(String apiSegment, Class<T> clazz, int itemsPerPage) throws IntegrationException {
        return this.getAllViewsFromApi(apiSegment, clazz, itemsPerPage, null);
    }

    public <T extends HubView> List<T> getAllViewsFromApi(String apiSegment, Class<T> clazz, int itemsPerPage, String mediaType) throws IntegrationException {
        HubPagedRequest hubPagedRequest = this.hubRequestFactory.createPagedRequest(itemsPerPage, Arrays.asList("api", apiSegment));
        return this.getAllViews(hubPagedRequest, clazz, mediaType);
    }

    public <T extends HubView> List<T> getAllViewsFromLinkSafely(HubView hubView, String metaLinkRef, Class<T> clazz) throws IntegrationException {
        return this.getAllViewsFromLinkSafely(hubView, metaLinkRef, clazz, null);
    }

    public <T extends HubView> List<T> getAllViewsFromLinkSafely(HubView hubView, String metaLinkRef, Class<T> clazz, String mediaType) throws IntegrationException {
        if (!this.metaHandler.hasLink(hubView, metaLinkRef)) {
            return Collections.emptyList();
        }
        return this.getAllViewsFromLink(hubView, metaLinkRef, clazz, mediaType);
    }

    public <T extends HubView> List<T> getAllViewsFromLink(HubView hubView, String metaLinkRef, Class<T> clazz) throws IntegrationException {
        return this.getAllViewsFromLink(hubView, metaLinkRef, clazz, null);
    }

    public <T extends HubView> List<T> getAllViewsFromLink(HubView hubView, String metaLinkRef, Class<T> clazz, String mediaType) throws IntegrationException {
        String link = this.metaHandler.getFirstLink(hubView, metaLinkRef);
        return this.getAllViews(link, clazz, mediaType);
    }

    public <T extends HubView> List<T> getAllViews(HubPagedRequest hubPagedRequest, Class<T> clazz) throws IntegrationException {
        return this.getAllViews(hubPagedRequest, clazz, null);
    }

    public <T extends HubView> List<T> getAllViews(String url, Class<T> clazz) throws IntegrationException {
        return this.getAllViews(url, clazz, null);
    }

    public <T extends HubView> List<T> getAllViews(String url, Class<T> clazz, String mediaType) throws IntegrationException {
        HubPagedRequest hubPagedRequest = this.hubRequestFactory.createPagedRequest(url);
        return this.getAllViews(hubPagedRequest, clazz, mediaType);
    }

    public <T extends HubView> List<T> getAllViews(HubPagedRequest hubPagedRequest, Class<T> clazz, String mediaType) throws IntegrationException {
        LinkedList<T> allViews = new LinkedList<T>();
        int totalCount = 0;
        int currentOffset = hubPagedRequest.offset;
        Response response = null;
        try {
            response = StringUtils.isNotBlank(mediaType) ? hubPagedRequest.executeGet(mediaType) : hubPagedRequest.executeGet();
            String jsonResponse = response.body().string();
            JsonObject jsonObject = this.jsonParser.parse(jsonResponse).getAsJsonObject();
            totalCount = jsonObject.get("totalCount").getAsInt();
            allViews.addAll(this.hubViewsTransformer.getViews(jsonObject, clazz));
            while (allViews.size() < totalCount && currentOffset < totalCount) {
                hubPagedRequest.offset = currentOffset += hubPagedRequest.limit;
                allViews.addAll(this.hubViewsTransformer.getViews(hubPagedRequest, clazz, mediaType));
            }
        }
        catch (IOException e) {
            try {
                throw new HubIntegrationException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(response);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)response);
        return allViews;
    }
}

