/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.report.pdf;

import com.blackducksoftware.integration.hub.report.api.BomComponent;
import com.blackducksoftware.integration.hub.report.api.ReportData;
import com.blackducksoftware.integration.hub.report.exception.RiskReportException;
import com.blackducksoftware.integration.hub.report.pdf.StringManager;
import com.blackducksoftware.integration.hub.report.pdf.util.PDFBoxManager;
import com.blackducksoftware.integration.log.IntLogger;
import com.blackducksoftware.integration.util.IntegrationEscapeUtil;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDRectangle;

public class PDFBoxWriter {
    private final IntLogger logger;
    private final String HIGH_RISK = "High Risk";
    private final String MED_RISK = "Medium Risk";
    private final String LOW_RISK = "Low Risk";
    private final String NO_RISK = "No Risk";
    private PDFBoxManager pdfManager;

    public PDFBoxWriter(IntLogger logger) {
        this.logger = logger;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File createPDFReportFile(File outputDirectory, ReportData report) throws RiskReportException {
        IntegrationEscapeUtil escapeUtil = new IntegrationEscapeUtil();
        String escapedProjectName = escapeUtil.escapeForUri(report.getProjectName());
        String escapedProjectVersionName = escapeUtil.escapeForUri(report.getProjectVersion());
        File pdfFile = new File(outputDirectory, escapedProjectName + "_" + escapedProjectVersionName + "_BlackDuck_RiskReport.pdf");
        if (pdfFile.exists()) {
            pdfFile.delete();
        }
        try (PDFBoxManager pdfManager = new PDFBoxManager(this.logger, pdfFile, new PDDocument());){
            this.pdfManager = pdfManager;
            PDRectangle pageBox = pdfManager.currentPage.getMediaBox();
            float pageWidth = pageBox.getWidth();
            float pageHeight = pageBox.getHeight();
            PDRectangle headerRectangle = this.writeHeader(pageWidth, pageHeight);
            PDRectangle bottomOfProjectInfoRectangle = this.writeProjectInformation(pageWidth, headerRectangle.getLowerLeftY(), report);
            PDRectangle bottomOfSummaryTableRectangle = this.writeSummaryTables(pageWidth, bottomOfProjectInfoRectangle.getLowerLeftY(), report);
            PDRectangle bottomOfComponentTableRectangle = this.writeComponentTable(pageWidth, bottomOfSummaryTableRectangle.getLowerLeftY(), report);
            File file = pdfFile;
            return file;
        }
        catch (IOException | URISyntaxException e) {
            String errorString = "Couldn't create the report: ";
            this.logger.trace("Couldn't create the report: " + e.getMessage(), e);
            throw new RiskReportException("Couldn't create the report: " + e.getMessage(), e);
        }
    }

    private PDRectangle writeHeader(float pageWidth, float startingHeight) throws IOException, URISyntaxException {
        PDRectangle rectangle = this.pdfManager.drawRectangle(0.0f, startingHeight - 100.0f, pageWidth, 100.0f, Color.BLACK);
        this.pdfManager.drawImage(pageWidth - 220.0f, rectangle.getLowerLeftY() + 27.5f, 203.0f, 45.0f, "/riskreport/web/images/Hub_BD_logo.png");
        this.pdfManager.writeText(5.0f, rectangle.getLowerLeftY() + 40.0f, "Black Duck Risk Report", PDFBoxManager.DEFAULT_FONT_BOLD, 20.0f, Color.WHITE);
        this.logger.trace("Finished writing the pdf header.");
        return rectangle;
    }

    private PDRectangle writeProjectInformation(float pageWidth, float startingHeight, ReportData reportData) throws IOException {
        float height = startingHeight - 18.0f;
        PDRectangle rectangle = this.pdfManager.writeWrappedLink(5.0f, height, 280.0f, reportData.getProjectName(), reportData.getProjectURL(), PDFBoxManager.DEFAULT_FONT, 18.0f);
        String dash = " - ";
        rectangle = this.pdfManager.writeText(5.0f + rectangle.getUpperRightX(), height, " - ", PDFBoxManager.DEFAULT_FONT, 18.0f, Color.BLACK);
        rectangle = this.pdfManager.writeWrappedLink(5.0f + rectangle.getUpperRightX(), height, 280.0f - rectangle.getWidth(), reportData.getProjectVersion(), reportData.getProjectVersionURL(), PDFBoxManager.DEFAULT_FONT, 18.0f);
        String projectAttributesString = "Phase:  " + reportData.getPhase() + "    |    Distribution:  " + reportData.getDistribution();
        rectangle = this.pdfManager.writeWrappedText(5.0f, rectangle.getLowerLeftY() - 18.0f, 300.0f, projectAttributesString);
        this.logger.trace("Finished writing the project information.");
        return rectangle;
    }

    private PDRectangle writeSummaryTables(float pageWidth, float startingHeight, ReportData reportData) throws IOException {
        float center = pageWidth / 2.0f;
        float height = startingHeight - 20.0f;
        this.writeSummaryTable(center - 180.0f, height, "Security Risk", reportData.getVulnerabilityRiskHighCount(), reportData.getVulnerabilityRiskMediumCount(), reportData.getVulnerabilityRiskLowCount(), reportData.getVulnerabilityRiskNoneCount(), reportData.getTotalComponents());
        this.writeSummaryTable(center, height, "License Risk", reportData.getLicenseRiskHighCount(), reportData.getLicenseRiskMediumCount(), reportData.getLicenseRiskLowCount(), reportData.getLicenseRiskNoneCount(), reportData.getTotalComponents());
        PDRectangle rectangle = this.writeSummaryTable(center + 180.0f, height, "Operational Risk", reportData.getOperationalRiskHighCount(), reportData.getOperationalRiskMediumCount(), reportData.getOperationalRiskLowCount(), reportData.getOperationalRiskNoneCount(), reportData.getTotalComponents());
        this.logger.trace("Finished writing the sumary tables.");
        return rectangle;
    }

    private PDRectangle writeSummaryTable(float centerX, float y, String title, int highCount, int mediumCount, int lowCount, int noneCount, int totalCount) throws IOException {
        PDRectangle rectangle = this.pdfManager.writeTextCentered(centerX, y, title, PDFBoxManager.DEFAULT_FONT_BOLD, 14.0f, Color.BLACK);
        rectangle = this.writeSummaryTableRow(centerX, rectangle.getLowerLeftY() - 14.0f, "High Risk", highCount, totalCount, Color.decode("#b52b24"));
        rectangle = this.writeSummaryTableRow(centerX, rectangle.getLowerLeftY() - 14.0f, "Medium Risk", mediumCount, totalCount, Color.decode("#eca4a0"));
        rectangle = this.writeSummaryTableRow(centerX, rectangle.getLowerLeftY() - 14.0f, "Low Risk", lowCount, totalCount, new Color(153, 153, 153));
        return this.writeSummaryTableRow(centerX, rectangle.getLowerLeftY() - 14.0f, "No Risk", noneCount, totalCount, new Color(221, 221, 221));
    }

    private PDRectangle writeSummaryTableRow(float centerX, float rowY, String rowTitle, int count, float totalCount, Color barColor) throws IOException {
        float rowTitleX = centerX - 80.0f;
        PDRectangle rectangle = this.pdfManager.writeText(rowTitleX, rowY, rowTitle);
        String countString = String.valueOf(count);
        this.pdfManager.writeTextCentered(centerX, rowY, countString);
        float barX = centerX + 20.0f;
        if (count > 0) {
            this.pdfManager.drawRectangle(barX, rowY, (float)count / totalCount * 60.0f, 10.0f, barColor);
        }
        return rectangle;
    }

    private PDRectangle writeComponentTable(float pageWidth, float startingHeight, ReportData reportData) throws IOException, URISyntaxException {
        float height = startingHeight - 20.0f;
        PDRectangle rectangle = this.pdfManager.writeText(30.0f, height, "BOM Entries " + reportData.getTotalComponents());
        PDRectangle rowRectangle = this.pdfManager.drawRectangle(10.0f, rectangle.getLowerLeftY() - 22.0f, pageWidth - 20.0f, 18.0f, new Color(221, 221, 221));
        float rowY = rowRectangle.getLowerLeftY() + 5.0f;
        this.pdfManager.writeText(50.0f, rowY, "Component", PDFBoxManager.DEFAULT_FONT_BOLD, 12.0f, PDFBoxManager.DEFAULT_COLOR);
        this.pdfManager.writeText(190.0f, rowY, "Version", PDFBoxManager.DEFAULT_FONT_BOLD, 12.0f, PDFBoxManager.DEFAULT_COLOR);
        this.pdfManager.writeText(310.0f, rowY, "License", PDFBoxManager.DEFAULT_FONT_BOLD, 12.0f, PDFBoxManager.DEFAULT_COLOR);
        this.pdfManager.writeText(430.0f, rowY, "H", PDFBoxManager.DEFAULT_FONT_BOLD, 12.0f, PDFBoxManager.DEFAULT_COLOR);
        this.pdfManager.writeText(470.0f, rowY, "M", PDFBoxManager.DEFAULT_FONT_BOLD, 12.0f, PDFBoxManager.DEFAULT_COLOR);
        this.pdfManager.writeText(510.0f, rowY, "L", PDFBoxManager.DEFAULT_FONT_BOLD, 12.0f, PDFBoxManager.DEFAULT_COLOR);
        this.pdfManager.writeText(550.0f, rowY, "Opt R", PDFBoxManager.DEFAULT_FONT_BOLD, 12.0f, PDFBoxManager.DEFAULT_COLOR);
        boolean isOdd = false;
        for (BomComponent component : reportData.getComponents()) {
            rowRectangle = this.writeComponentRow(pageWidth, rowRectangle.getLowerLeftY(), component, isOdd);
            isOdd = !isOdd;
        }
        this.logger.trace("Finished writing the component table.");
        return rowRectangle;
    }

    private PDRectangle writeComponentRow(float pageWidth, float y, BomComponent component, boolean isOdd) throws IOException, URISyntaxException {
        float componentNameWidth = 125.0f;
        float componentVersionWidth = 115.0f;
        float componentLicenseWidth = 150.0f;
        List<String> componentNameTextLines = StringManager.wrapToCombinedList(component.getComponentName(), Math.round(125.0f));
        List<String> componentVersionTextLines = StringManager.wrapToCombinedList(component.getComponentVersion(), Math.round(125.0f));
        List<String> componentLicenseTextLines = StringManager.wrapToCombinedList(component.getLicense(), Math.round(125.0f));
        float rowHeight = this.pdfManager.getApproximateWrappedStringHeight(componentNameTextLines.size(), 10.0f);
        float componentVersionHeight = this.pdfManager.getApproximateWrappedStringHeight(componentVersionTextLines.size(), 10.0f);
        float componentLicenseHeight = this.pdfManager.getApproximateWrappedStringHeight(componentLicenseTextLines.size(), 10.0f);
        if (componentVersionHeight > rowHeight) {
            rowHeight = componentVersionHeight;
        }
        if (componentLicenseHeight > rowHeight) {
            rowHeight = componentLicenseHeight;
        }
        PDRectangle rowRectangle = null;
        Color rowColor = Color.WHITE;
        if (isOdd) {
            rowColor = new Color(221, 221, 221);
            rowRectangle = this.pdfManager.drawRectangle(10.0f, y - rowHeight, pageWidth - 20.0f, rowHeight, rowColor);
        } else {
            rowRectangle = this.pdfManager.drawRectangle(10.0f, y - rowHeight, pageWidth - 20.0f, rowHeight, rowColor);
        }
        float rowUpperY = rowRectangle.getUpperRightY();
        if (StringUtils.isNotBlank(component.getPolicyStatus()) && component.getPolicyStatus().equalsIgnoreCase("IN_VIOLATION")) {
            this.pdfManager.drawImageCentered(15.0f, rowUpperY, 8.0f, 8.0f, 0.0f, rowHeight, "/riskreport/web/images/cross_through_circle.png");
        }
        this.pdfManager.writeWrappedVerticalCenteredLink(30.0f, rowUpperY, 125.0f, rowHeight, componentNameTextLines, component.getComponentURL(), PDFBoxManager.DEFAULT_COLOR);
        this.pdfManager.writeWrappedCenteredLink(210.0f, rowUpperY, 115.0f, rowHeight, componentVersionTextLines, component.getComponentVersionURL(), PDFBoxManager.DEFAULT_COLOR);
        Risk licenseRisk = this.getLicenseRisk(component, rowColor);
        if (StringUtils.isNotBlank(licenseRisk.riskShortString)) {
            this.pdfManager.drawRectangleCentered(282.0f, rowUpperY - 1.0f, 12.0f, 12.0f, rowHeight, licenseRisk.riskColor);
            this.pdfManager.writeTextCentered(282.0f, rowUpperY, rowHeight, licenseRisk.riskShortString);
        }
        this.pdfManager.writeWrappedVerticalCenteredText(290.0f, rowUpperY, 150.0f, rowHeight, componentLicenseTextLines);
        this.pdfManager.writeTextCentered(434.0f, rowUpperY, rowHeight, String.valueOf(component.getSecurityRiskHighCount()));
        this.pdfManager.writeTextCentered(477.0f, rowUpperY, rowHeight, String.valueOf(component.getSecurityRiskMediumCount()));
        this.pdfManager.writeTextCentered(520.0f, rowUpperY, rowHeight, String.valueOf(component.getSecurityRiskLowCount()));
        Risk operationalRisk = this.getOperationalRisk(component, rowColor);
        this.pdfManager.drawRectangle(545.0f, rowRectangle.getLowerLeftY(), 60.0f, rowHeight, operationalRisk.riskColor);
        this.pdfManager.writeTextCentered(575.0f, rowUpperY, rowHeight, operationalRisk.riskShortString, PDFBoxManager.DEFAULT_FONT_BOLD, 12.0f, PDFBoxManager.DEFAULT_COLOR);
        return rowRectangle;
    }

    public Risk getLicenseRisk(BomComponent component, Color noColor) {
        Risk risk = new Risk();
        risk.riskShortString = "";
        risk.riskColor = noColor;
        if (component.getLicenseRiskHighCount() > 0) {
            risk.riskShortString = "H";
            risk.riskColor = Color.decode("#b52b24");
        } else if (component.getLicenseRiskMediumCount() > 0) {
            risk.riskShortString = "M";
            risk.riskColor = Color.decode("#eca4a0");
        } else if (component.getLicenseRiskLowCount() > 0) {
            risk.riskShortString = "L";
            risk.riskColor = new Color(153, 153, 153);
        }
        return risk;
    }

    public Risk getOperationalRisk(BomComponent component, Color noColor) {
        Risk risk = new Risk();
        risk.riskShortString = "-";
        risk.riskColor = noColor;
        if (component.getOperationalRiskHighCount() > 0) {
            risk.riskShortString = "H";
            risk.riskColor = Color.decode("#b52b24");
        } else if (component.getOperationalRiskMediumCount() > 0) {
            risk.riskShortString = "M";
            risk.riskColor = Color.decode("#eca4a0");
        } else if (component.getOperationalRiskLowCount() > 0) {
            risk.riskShortString = "L";
            risk.riskColor = new Color(153, 153, 153);
        }
        return risk;
    }

    private class Risk {
        public String riskShortString;
        public Color riskColor;

        private Risk() {
        }
    }
}

