/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.dataservice.notification.transformer;

import com.blackducksoftware.integration.hub.api.notification.NotificationService;
import com.blackducksoftware.integration.hub.api.policy.PolicyService;
import com.blackducksoftware.integration.hub.api.project.version.ProjectVersionService;
import com.blackducksoftware.integration.hub.api.view.MetaHandler;
import com.blackducksoftware.integration.hub.dataservice.model.ProjectVersionModel;
import com.blackducksoftware.integration.hub.dataservice.notification.model.NotificationContentItem;
import com.blackducksoftware.integration.hub.dataservice.notification.model.VulnerabilityContentItem;
import com.blackducksoftware.integration.hub.dataservice.notification.transformer.AbstractNotificationTransformer;
import com.blackducksoftware.integration.hub.exception.HubIntegrationException;
import com.blackducksoftware.integration.hub.exception.HubItemTransformException;
import com.blackducksoftware.integration.hub.model.view.ComponentVersionView;
import com.blackducksoftware.integration.hub.model.view.NotificationView;
import com.blackducksoftware.integration.hub.model.view.VulnerabilityNotificationView;
import com.blackducksoftware.integration.hub.model.view.components.AffectedProjectVersion;
import com.blackducksoftware.integration.hub.model.view.components.VulnerabilityNotificationContent;
import com.blackducksoftware.integration.hub.model.view.components.VulnerabilitySourceQualifiedId;
import com.blackducksoftware.integration.hub.service.HubService;
import com.blackducksoftware.integration.log.IntLogger;
import java.util.ArrayList;
import java.util.List;

public class VulnerabilityTransformer
extends AbstractNotificationTransformer {
    private final IntLogger logger;

    public VulnerabilityTransformer(HubService hubResponseService, NotificationService notificationService, ProjectVersionService projectVersionService, PolicyService policyService, MetaHandler metaService, IntLogger logger) {
        super(hubResponseService, notificationService, projectVersionService, policyService, metaService);
        this.logger = logger;
    }

    @Override
    public List<NotificationContentItem> transform(NotificationView item) throws HubItemTransformException {
        ArrayList<NotificationContentItem> notificationContentItems;
        block7: {
            notificationContentItems = new ArrayList<NotificationContentItem>();
            try {
                VulnerabilityNotificationView vulnerabilityNotificationItem = (VulnerabilityNotificationView)item;
                VulnerabilityNotificationContent vulnerabilityNotificationContent = vulnerabilityNotificationItem.content;
                String componentName = vulnerabilityNotificationContent.componentName;
                String componentVersionUrl = vulnerabilityNotificationContent.componentVersionLink;
                ComponentVersionView fullComponentVersion = this.getComponentVersion(componentVersionUrl);
                List<VulnerabilitySourceQualifiedId> addedVulnList = this.extractIdList(vulnerabilityNotificationContent.newVulnerabilityCount, vulnerabilityNotificationContent.newVulnerabilityIds);
                List<VulnerabilitySourceQualifiedId> updatedVulnList = this.extractIdList(vulnerabilityNotificationContent.updatedVulnerabilityCount, vulnerabilityNotificationContent.updatedVulnerabilityIds);
                List<VulnerabilitySourceQualifiedId> deletedVulnList = this.extractIdList(vulnerabilityNotificationContent.deletedVulnerabilityCount, vulnerabilityNotificationContent.deletedVulnerabilityIds);
                List<AffectedProjectVersion> affectedProjectVersionList = vulnerabilityNotificationItem.content.affectedProjectVersions;
                if (affectedProjectVersionList == null || affectedProjectVersionList.isEmpty()) {
                    notificationContentItems.add(new VulnerabilityContentItem(item.createdAt, new ProjectVersionModel(), componentName, fullComponentVersion, componentVersionUrl, addedVulnList, updatedVulnList, deletedVulnList, null));
                    break block7;
                }
                for (AffectedProjectVersion affectedProjectVersion : affectedProjectVersionList) {
                    ProjectVersionModel fullProjectVersion;
                    try {
                        fullProjectVersion = this.createFullProjectVersion(affectedProjectVersion.projectVersion, affectedProjectVersion.projectName, affectedProjectVersion.projectVersionName);
                    }
                    catch (HubIntegrationException e) {
                        Throwable originalException = this.getOriginalException(e);
                        if (originalException.getMessage().contains("Forbidden")) {
                            this.logger.warn(String.format("Skipping an affected projectVersion for this vulnerability. ProjectVersion: %s / %s; Reason: %s", affectedProjectVersion.projectName, affectedProjectVersion.projectVersionName, e.getMessage()));
                            continue;
                        }
                        throw e;
                    }
                    notificationContentItems.add(new VulnerabilityContentItem(item.createdAt, fullProjectVersion, componentName, fullComponentVersion, componentVersionUrl, addedVulnList, updatedVulnList, deletedVulnList, affectedProjectVersion.componentIssueUrl));
                }
            }
            catch (Exception e) {
                throw new HubItemTransformException(e);
            }
        }
        return notificationContentItems;
    }

    private Throwable getOriginalException(HubIntegrationException e) {
        Throwable originalException = e;
        while (originalException.getCause() != null) {
            originalException = originalException.getCause();
        }
        return originalException;
    }

    private List<VulnerabilitySourceQualifiedId> extractIdList(int count, List<VulnerabilitySourceQualifiedId> idList) {
        if (count > 0 && idList != null && idList.size() > 0) {
            return idList;
        }
        return new ArrayList<VulnerabilitySourceQualifiedId>();
    }
}

