/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.dataservice.notification.transformer;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.api.notification.NotificationService;
import com.blackducksoftware.integration.hub.api.policy.PolicyService;
import com.blackducksoftware.integration.hub.api.project.version.ProjectVersionService;
import com.blackducksoftware.integration.hub.api.view.MetaHandler;
import com.blackducksoftware.integration.hub.dataservice.model.ProjectVersionModel;
import com.blackducksoftware.integration.hub.dataservice.notification.model.NotificationContentItem;
import com.blackducksoftware.integration.hub.dataservice.notification.model.PolicyNotificationFilter;
import com.blackducksoftware.integration.hub.dataservice.notification.model.PolicyViolationContentItem;
import com.blackducksoftware.integration.hub.dataservice.notification.transformer.AbstractPolicyTransformer;
import com.blackducksoftware.integration.hub.exception.HubItemTransformException;
import com.blackducksoftware.integration.hub.model.view.ComponentVersionView;
import com.blackducksoftware.integration.hub.model.view.NotificationView;
import com.blackducksoftware.integration.hub.model.view.PolicyRuleView;
import com.blackducksoftware.integration.hub.model.view.ProjectVersionView;
import com.blackducksoftware.integration.hub.model.view.RuleViolationNotificationView;
import com.blackducksoftware.integration.hub.model.view.components.ComponentVersionStatus;
import com.blackducksoftware.integration.hub.service.HubService;
import com.blackducksoftware.integration.log.IntLogger;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

public class PolicyViolationTransformer
extends AbstractPolicyTransformer {
    public PolicyViolationTransformer(HubService hubResponseService, NotificationService notificationService, ProjectVersionService projectVersionService, PolicyService policyService, PolicyNotificationFilter policyFilter, MetaHandler metaService) {
        super(hubResponseService, notificationService, projectVersionService, policyService, policyFilter, metaService);
    }

    public PolicyViolationTransformer(HubService hubResponseService, IntLogger logger, NotificationService notificationService, ProjectVersionService projectVersionService, PolicyService policyService, PolicyNotificationFilter policyFilter, MetaHandler metaService) {
        super(hubResponseService, logger, notificationService, projectVersionService, policyService, policyFilter, metaService);
    }

    @Override
    public List<NotificationContentItem> transform(NotificationView item) throws HubItemTransformException {
        ProjectVersionView releaseItem;
        ArrayList<NotificationContentItem> templateData = new ArrayList<NotificationContentItem>();
        RuleViolationNotificationView policyViolation = (RuleViolationNotificationView)item;
        String projectName = policyViolation.content.projectName;
        List<ComponentVersionStatus> componentVersionList = policyViolation.content.componentVersionStatuses;
        String projectVersionLink = policyViolation.content.projectVersionLink;
        try {
            releaseItem = this.getReleaseItem(projectVersionLink);
        }
        catch (IntegrationException e) {
            throw new HubItemTransformException(e);
        }
        this.handleNotification(componentVersionList, projectName, releaseItem, item, templateData);
        return templateData;
    }

    @Override
    public void handleNotification(List<ComponentVersionStatus> componentVersionList, String projectName, ProjectVersionView releaseItem, NotificationView item, List<NotificationContentItem> templateData) throws HubItemTransformException {
        for (ComponentVersionStatus componentVersion : componentVersionList) {
            try {
                ProjectVersionModel projectVersion;
                RuleViolationNotificationView policyViolation = (RuleViolationNotificationView)item;
                try {
                    projectVersion = this.createFullProjectVersion(policyViolation.content.projectVersionLink, projectName, releaseItem.versionName);
                }
                catch (IntegrationException e) {
                    throw new HubItemTransformException("Error getting ProjectVersion from Hub" + e.getMessage(), e);
                }
                String componentVersionLink = componentVersion.componentVersionLink;
                ComponentVersionView fullComponentVersion = this.getComponentVersion(componentVersionLink);
                if (componentVersion.policies == null || componentVersion.policies.size() == 0) {
                    throw new HubItemTransformException("The polices list in the component version status is null or empty");
                }
                List<String> ruleList = this.getMatchingRuleUrls(componentVersion.policies);
                if (ruleList == null || ruleList.isEmpty()) continue;
                ArrayList<PolicyRuleView> policyRuleList = new ArrayList<PolicyRuleView>();
                for (String ruleUrl : ruleList) {
                    PolicyRuleView rule = this.getPolicyRule(ruleUrl);
                    policyRuleList.add(rule);
                }
                this.createContents(projectVersion, componentVersion.componentName, fullComponentVersion, componentVersion.componentLink, componentVersion.componentVersionLink, policyRuleList, item, templateData, componentVersion.componentIssueLink);
            }
            catch (Exception e) {
                throw new HubItemTransformException(e);
            }
        }
    }

    private ProjectVersionView getReleaseItem(String projectVersionLink) throws IntegrationException {
        ProjectVersionView releaseItem = this.getProjectVersionService().getView(projectVersionLink, ProjectVersionView.class);
        return releaseItem;
    }

    @Override
    public void createContents(ProjectVersionModel projectVersion, String componentName, ComponentVersionView componentVersion, String componentUrl, String componentVersionUrl, List<PolicyRuleView> policyRuleList, NotificationView item, List<NotificationContentItem> templateData, String componentIssueUrl) throws URISyntaxException {
        templateData.add(new PolicyViolationContentItem(item.createdAt, projectVersion, componentName, componentVersion, componentUrl, componentVersionUrl, policyRuleList, componentIssueUrl));
    }
}

