/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.api.report;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.api.report.ReportCategoriesEnum;
import com.blackducksoftware.integration.hub.api.report.VersionReport;
import com.blackducksoftware.integration.hub.exception.HubIntegrationException;
import com.blackducksoftware.integration.hub.model.enumeration.ReportFormatEnum;
import com.blackducksoftware.integration.hub.model.enumeration.ReportTypeEnum;
import com.blackducksoftware.integration.hub.model.view.ProjectVersionView;
import com.blackducksoftware.integration.hub.model.view.ReportView;
import com.blackducksoftware.integration.hub.request.HubRequest;
import com.blackducksoftware.integration.hub.rest.RestConnection;
import com.blackducksoftware.integration.hub.rest.exception.IntegrationRestException;
import com.blackducksoftware.integration.hub.service.HubService;
import com.blackducksoftware.integration.log.IntLogger;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;

public class ReportService
extends HubService {
    public static final long DEFAULT_TIMEOUT = 300000L;
    private final IntLogger logger;
    private final long timeoutInMilliseconds;

    public ReportService(RestConnection restConnection, IntLogger logger) {
        this(restConnection, logger, 300000L);
    }

    public ReportService(RestConnection restConnection, IntLogger logger, long timeoutInMilliseconds) {
        super(restConnection);
        this.logger = logger;
        long timeout = timeoutInMilliseconds;
        if (timeoutInMilliseconds <= 0L) {
            timeout = 300000L;
            logger.alwaysLog(timeoutInMilliseconds + "ms is not a valid BOM wait time, using : " + timeout + "ms instead");
        }
        this.timeoutInMilliseconds = timeout;
    }

    public String startGeneratingHubReport(ProjectVersionView version, ReportFormatEnum reportFormat, ReportCategoriesEnum[] categories) throws IntegrationException {
        return this.startGeneratingHubReport(this.getFirstLink(version, "versionReport"), ReportTypeEnum.VERSION, reportFormat, categories);
    }

    public String startGeneratingHubNoticesReport(ProjectVersionView version, ReportFormatEnum reportFormat) throws IntegrationException {
        return this.startGeneratingHubReport(this.getFirstLink(version, "licenseReports"), ReportTypeEnum.VERSION_LICENSE, reportFormat, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String startGeneratingHubReport(String reportUrl, ReportTypeEnum reportType, ReportFormatEnum reportFormat, ReportCategoriesEnum[] categories) throws IntegrationException {
        JsonObject json = new JsonObject();
        json.addProperty("reportFormat", reportFormat.toString());
        json.addProperty("reportType", reportType.toString());
        if (categories != null) {
            JsonArray categoriesJson = new JsonArray();
            for (ReportCategoriesEnum category : categories) {
                categoriesJson.add(category.name());
            }
            json.add("categories", categoriesJson);
        }
        HubRequest hubRequest = this.getHubRequestFactory().createRequest(reportUrl);
        try (Response response = null;){
            response = hubRequest.executePost(this.getGson().toJson(json));
            String string = response.header("location");
            return string;
        }
    }

    public void deleteHubReport(String reportUrl) throws IntegrationException {
        HubRequest hubRequest = this.getHubRequestFactory().createRequest(reportUrl);
        hubRequest.executeDelete();
    }

    public VersionReport getReportContent(String reportContentUrl) throws IntegrationException {
        JsonElement fileContent = this.getReportContentJson(reportContentUrl);
        VersionReport report = this.getGson().fromJson(fileContent, VersionReport.class);
        return report;
    }

    public String getNoticesReportContent(String reportContentUrl) throws IntegrationException {
        JsonElement fileContent = this.getReportContentJson(reportContentUrl);
        return fileContent.getAsString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonElement getReportContentJson(String reportContentUrl) throws IntegrationException {
        HubRequest hubRequest = this.getHubRequestFactory().createRequest(reportContentUrl);
        Response response = null;
        try {
            response = hubRequest.executeGet();
            String jsonResponse = this.readResponseString(response);
            JsonObject json = this.getJsonParser().parse(jsonResponse).getAsJsonObject();
            JsonElement content = json.get("reportContent");
            JsonArray reportConentArray = content.getAsJsonArray();
            JsonObject reportFile = reportConentArray.get(0).getAsJsonObject();
            JsonElement jsonElement = reportFile.get("fileContent");
            return jsonElement;
        }
        finally {
            IOUtils.closeQuietly((Closeable)response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReportView isReportFinishedGenerating(String reportUrl) throws IntegrationException {
        long startTime = System.currentTimeMillis();
        long elapsedTime = 0L;
        Date timeFinished = null;
        ReportView reportInfo = null;
        while (timeFinished == null) {
            HubRequest hubRequest = this.getHubRequestFactory().createRequest(reportUrl);
            Response response = null;
            try {
                response = hubRequest.executeGet();
                String jsonResponse = this.readResponseString(response);
                reportInfo = this.getViewAs(jsonResponse, ReportView.class);
            }
            finally {
                IOUtils.closeQuietly((Closeable)response);
            }
            timeFinished = reportInfo.finishedAt;
            if (timeFinished != null) break;
            if (elapsedTime >= this.timeoutInMilliseconds) {
                String formattedTime = String.format("%d minutes", TimeUnit.MILLISECONDS.toMinutes(this.timeoutInMilliseconds));
                throw new HubIntegrationException("The Report has not finished generating in : " + formattedTime);
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                throw new HubIntegrationException("The thread waiting for the report generation was interrupted", e);
            }
            elapsedTime = System.currentTimeMillis() - startTime;
        }
        return reportInfo;
    }

    public VersionReport generateHubReport(ProjectVersionView version, ReportFormatEnum reportFormat, ReportCategoriesEnum[] categories) throws IntegrationException {
        this.logger.debug("Starting the Report generation.");
        String reportUrl = this.startGeneratingHubReport(version, reportFormat, categories);
        this.logger.debug("Waiting for the Report to complete.");
        ReportView reportInfo = this.isReportFinishedGenerating(reportUrl);
        String contentLink = this.getFirstLink(reportInfo, "content");
        if (contentLink == null) {
            throw new HubIntegrationException("Could not find content link for the report at : " + reportUrl);
        }
        this.logger.debug("Getting the Report content.");
        VersionReport report = this.getReportContent(contentLink);
        this.logger.debug("Finished retrieving the Report.");
        this.logger.debug("Cleaning up the Report on the server.");
        this.deleteHubReport(reportUrl);
        return report;
    }

    public String generateHubNoticesReport(ProjectVersionView version, ReportFormatEnum reportFormat) throws IntegrationException {
        block5: {
            if (this.hasLink(version, "licenseReports")) {
                try {
                    this.logger.debug("Starting the Notices Report generation.");
                    String reportUrl = this.startGeneratingHubNoticesReport(version, reportFormat);
                    this.logger.debug("Waiting for the Notices Report to complete.");
                    ReportView reportInfo = this.isReportFinishedGenerating(reportUrl);
                    String contentLink = this.getFirstLink(reportInfo, "content");
                    if (contentLink == null) {
                        throw new HubIntegrationException("Could not find content link for the report at : " + reportUrl);
                    }
                    this.logger.debug("Getting the Notices Report content.");
                    String noticesReport = this.getNoticesReportContent(contentLink);
                    this.logger.debug("Finished retrieving the Notices Report.");
                    this.logger.debug("Cleaning up the Notices Report on the server.");
                    this.deleteHubReport(reportUrl);
                    return noticesReport;
                }
                catch (IntegrationRestException e) {
                    if (e.getHttpStatusCode() == 402) {
                        this.logger.warn("Can not create the notice report, the Hub notice module is not enabled.");
                        break block5;
                    }
                    throw e;
                }
            }
            this.logger.warn("Can not create the notice report, the Hub notice module is not enabled.");
        }
        return null;
    }
}

