/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.api.nonpublic.HubVersionService;
import com.blackducksoftware.integration.hub.capability.HubCapabilitiesEnum;
import com.blackducksoftware.integration.hub.exception.HubIntegrationException;
import com.blackducksoftware.integration.log.IntLogger;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.Set;

public class HubSupportHelper
implements Serializable {
    private static final long serialVersionUID = 6440466357358359056L;
    private boolean hasBeenChecked = false;
    private final Set<HubCapabilitiesEnum> capabilities = EnumSet.noneOf(HubCapabilitiesEnum.class);

    public boolean isHasBeenChecked() {
        return this.hasBeenChecked;
    }

    public void setHasBeenChecked(boolean hasBeenChecked) {
        this.hasBeenChecked = hasBeenChecked;
    }

    public void checkHubSupport(HubVersionService hubVersionRequestService, IntLogger logger) throws IntegrationException {
        block17: {
            try {
                if (hubVersionRequestService.isConsumerVersionLessThanOrEqualToServerVersion("4.4.0")) {
                    this.setHub4_4Support();
                } else if (hubVersionRequestService.isConsumerVersionLessThanOrEqualToServerVersion("3.7.0")) {
                    this.setHub3_7Support();
                } else if (hubVersionRequestService.isConsumerVersionLessThanOrEqualToServerVersion("3.6.0")) {
                    this.setHub3_6Support();
                } else if (hubVersionRequestService.isConsumerVersionLessThanOrEqualToServerVersion("3.5.0")) {
                    this.setHub3_5Support();
                } else if (hubVersionRequestService.isConsumerVersionLessThanOrEqualToServerVersion("3.4.0")) {
                    this.setHub3_4_0Support();
                } else if (hubVersionRequestService.isConsumerVersionLessThanOrEqualToServerVersion("3.3.1")) {
                    this.setHub3_3_1Support();
                } else if (hubVersionRequestService.isConsumerVersionLessThanOrEqualToServerVersion("3.1.0")) {
                    this.setHub3_1Support();
                } else if (hubVersionRequestService.isConsumerVersionLessThanOrEqualToServerVersion("3.0.0")) {
                    this.setHub3_0Support();
                }
                this.setHasBeenChecked(true);
            }
            catch (HubIntegrationException e) {
                if (logger == null) break block17;
                logger.error(e.getMessage(), e);
            }
        }
    }

    public boolean hasCapability(HubCapabilitiesEnum capability) {
        return this.capabilities.contains((Object)capability);
    }

    private void setHub3_0Support() {
        this.capabilities.add(HubCapabilitiesEnum.JRE_PROVIDED);
        this.capabilities.add(HubCapabilitiesEnum.POLICY_API);
        this.capabilities.add(HubCapabilitiesEnum.CLI_STATUS_DIRECTORY_OPTION);
    }

    private void setHub3_1Support() {
        this.setHub3_0Support();
        this.capabilities.add(HubCapabilitiesEnum.CLI_PASSWORD_ENVIRONMENT_VARIABLE);
    }

    private void setHub3_3_1Support() {
        this.setHub3_1Support();
        this.capabilities.add(HubCapabilitiesEnum.BOM_FILE_UPLOAD);
    }

    private void setHub3_4_0Support() {
        this.setHub3_3_1Support();
        this.capabilities.add(HubCapabilitiesEnum.AGGREGATE_BOM_REST_SERVER);
    }

    private void setHub3_5Support() {
        this.setHub3_4_0Support();
        this.capabilities.add(HubCapabilitiesEnum.CODE_LOCATION_ALIAS);
    }

    private void setHub3_6Support() {
        this.setHub3_5Support();
        this.capabilities.add(HubCapabilitiesEnum.CLI_INSECURE_OPTION);
    }

    private void setHub3_7Support() {
        this.setHub3_6Support();
        this.capabilities.add(HubCapabilitiesEnum.ISSUE_TRACKER);
    }

    private void setHub4_4Support() {
        this.setHub3_7Support();
        this.capabilities.add(HubCapabilitiesEnum.CLI_SNIPPET_MODE);
    }
}

