/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.service;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.model.HubView;
import com.blackducksoftware.integration.hub.request.HubPagedRequest;
import com.blackducksoftware.integration.hub.service.HubViewTransformer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.LinkedList;
import java.util.List;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;

public class HubViewsTransformer {
    private final HubViewTransformer hubViewTransformer;
    private final JsonParser jsonParser;

    public HubViewsTransformer(HubViewTransformer hubResponseItemManager, JsonParser jsonParser) {
        this.hubViewTransformer = hubResponseItemManager;
        this.jsonParser = jsonParser;
    }

    public <T extends HubView> List<T> getViews(JsonArray viewsArray, Class<T> clazz) {
        LinkedList<T> itemList = new LinkedList<T>();
        for (JsonElement element : viewsArray) {
            T item = this.hubViewTransformer.getViewAs(element, clazz);
            itemList.add(item);
        }
        return itemList;
    }

    public <T extends HubView> List<T> getViews(JsonObject jsonObject, Class<T> clazz) throws IntegrationException {
        LinkedList<T> viewList = new LinkedList<T>();
        JsonElement viewsElement = jsonObject.get("items");
        JsonArray viewsArray = viewsElement.getAsJsonArray();
        for (JsonElement element : viewsArray) {
            T item = this.hubViewTransformer.getViewAs(element, clazz);
            viewList.add(item);
        }
        return viewList;
    }

    public <T extends HubView> List<T> getViews(HubPagedRequest hubPagedRequest, Class<T> clazz) throws IntegrationException {
        return this.getViews(hubPagedRequest, clazz, null);
    }

    public <T extends HubView> List<T> getViews(HubPagedRequest hubPagedRequest, Class<T> clazz, String mediaType) throws IntegrationException {
        try (Response response = null;){
            response = StringUtils.isNotBlank(mediaType) ? hubPagedRequest.executeGet(mediaType) : hubPagedRequest.executeGet();
            String jsonResponse = response.body().string();
            JsonObject jsonObject = this.jsonParser.parse(jsonResponse).getAsJsonObject();
            List<T> list = this.getViews(jsonObject, clazz);
            return list;
        }
    }
}

