/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.rest.oauth;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.proxy.ProxyInfo;
import com.blackducksoftware.integration.hub.rest.RestConnection;
import com.blackducksoftware.integration.hub.rest.oauth.AccessType;
import com.blackducksoftware.integration.hub.rest.oauth.OkOauthAuthenticator;
import com.blackducksoftware.integration.hub.rest.oauth.TokenManager;
import com.blackducksoftware.integration.log.IntLogger;
import java.net.URL;

public class OAuthRestConnection
extends RestConnection {
    private final TokenManager tokenManager;
    private final AccessType accessType;

    public OAuthRestConnection(IntLogger logger, URL hubBaseUrl, int timeout, TokenManager tokenManager, AccessType accessType, ProxyInfo proxyInfo) {
        super(logger, hubBaseUrl, timeout, proxyInfo);
        this.tokenManager = tokenManager;
        this.accessType = accessType;
    }

    @Override
    public void addBuilderAuthentication() throws IntegrationException {
        this.builder.authenticator(new OkOauthAuthenticator(this.tokenManager, this.accessType, this));
    }

    @Override
    public void clientAuthenticate() throws IntegrationException {
        this.tokenManager.refreshToken(this.accessType);
    }
}

