/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.notification.processor;

import com.blackducksoftware.integration.hub.exception.HubIntegrationException;
import com.blackducksoftware.integration.hub.notification.processor.SubProcessorCache;
import com.blackducksoftware.integration.hub.notification.processor.event.NotificationEvent;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class MapProcessorCache
implements SubProcessorCache {
    private final Map<String, NotificationEvent> eventMap = new LinkedHashMap<String, NotificationEvent>(500);

    @Override
    public boolean hasEvent(String eventKey) {
        return this.eventMap.containsKey(eventKey);
    }

    @Override
    public void addEvent(NotificationEvent event) {
        String key = event.getEventKey();
        if (!this.eventMap.containsKey(key)) {
            this.eventMap.put(key, event);
        } else {
            NotificationEvent storedEvent = this.eventMap.get(key);
            Map<String, Object> storedEventDataMap = storedEvent.getDataSet();
            Map<String, Object> eventDataMap = event.getDataSet();
            storedEventDataMap.putAll(eventDataMap);
        }
    }

    public void removeEvent(String eventKey) {
        if (this.eventMap.containsKey(eventKey)) {
            this.eventMap.remove(eventKey);
        }
    }

    @Override
    public void removeEvent(NotificationEvent event) {
        String key = event.getEventKey();
        this.removeEvent(key);
    }

    public NotificationEvent getEvent(String eventKey) {
        return this.eventMap.get(eventKey);
    }

    @Override
    public Collection<NotificationEvent> getEvents() throws HubIntegrationException {
        return this.eventMap.values();
    }

    public Map<String, NotificationEvent> getEventMap() {
        return this.eventMap;
    }
}

