/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.global;

import com.blackducksoftware.integration.exception.EncryptionException;
import com.blackducksoftware.integration.hub.Credentials;
import com.blackducksoftware.integration.hub.model.HubComponent;
import com.blackducksoftware.integration.hub.proxy.ProxyInfo;
import com.blackducksoftware.integration.hub.rest.ApiKeyRestConnection;
import com.blackducksoftware.integration.hub.rest.ApiKeyRestConnectionBuilder;
import com.blackducksoftware.integration.hub.rest.CredentialsRestConnection;
import com.blackducksoftware.integration.hub.rest.CredentialsRestConnectionBuilder;
import com.blackducksoftware.integration.hub.rest.RestConnection;
import com.blackducksoftware.integration.log.IntLogger;
import java.io.Serializable;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;

public class HubServerConfig
extends HubComponent
implements Serializable {
    private static final long serialVersionUID = -1581638027683631935L;
    private final URL hubUrl;
    private final int timeoutSeconds;
    private final Credentials credentials;
    private final String apiKey;
    private final ProxyInfo proxyInfo;
    private final boolean alwaysTrustServerCertificate;

    public HubServerConfig(URL url, int timeoutSeconds, Credentials credentials, ProxyInfo proxyInfo, boolean alwaysTrustServerCertificate) {
        this.hubUrl = url;
        this.timeoutSeconds = timeoutSeconds;
        this.credentials = credentials;
        this.apiKey = null;
        this.proxyInfo = proxyInfo;
        this.alwaysTrustServerCertificate = alwaysTrustServerCertificate;
    }

    public HubServerConfig(URL url, int timeoutSeconds, String apiKey, ProxyInfo proxyInfo, boolean alwaysTrustServerCertificate) {
        this.hubUrl = url;
        this.timeoutSeconds = timeoutSeconds;
        this.credentials = null;
        this.apiKey = apiKey;
        this.proxyInfo = proxyInfo;
        this.alwaysTrustServerCertificate = alwaysTrustServerCertificate;
    }

    public boolean shouldUseProxyForHub() {
        return this.proxyInfo != null && this.proxyInfo.shouldUseProxyForUrl(this.hubUrl);
    }

    public void print(IntLogger logger) {
        if (this.getHubUrl() != null) {
            logger.alwaysLog("--> Hub Server Url : " + this.getHubUrl());
        }
        if (this.getGlobalCredentials() != null && StringUtils.isNotBlank(this.getGlobalCredentials().getUsername())) {
            logger.alwaysLog("--> Hub User : " + this.getGlobalCredentials().getUsername());
        }
        if (StringUtils.isNotBlank(this.apiKey)) {
            logger.alwaysLog("--> Hub API Key Used");
        }
        if (this.alwaysTrustServerCertificate) {
            logger.alwaysLog("--> Trust Hub certificate : " + this.isAlwaysTrustServerCertificate());
        }
        if (this.proxyInfo != null) {
            if (StringUtils.isNotBlank(this.proxyInfo.getHost())) {
                logger.alwaysLog("--> Proxy Host : " + this.proxyInfo.getHost());
            }
            if (this.proxyInfo.getPort() > 0) {
                logger.alwaysLog("--> Proxy Port : " + this.proxyInfo.getPort());
            }
            if (StringUtils.isNotBlank(this.proxyInfo.getIgnoredProxyHosts())) {
                logger.alwaysLog("--> No Proxy Hosts : " + this.proxyInfo.getIgnoredProxyHosts());
            }
            if (StringUtils.isNotBlank(this.proxyInfo.getUsername())) {
                logger.alwaysLog("--> Proxy Username : " + this.proxyInfo.getUsername());
            }
        }
    }

    public RestConnection createRestConnection(IntLogger logger) throws EncryptionException {
        if (StringUtils.isNotBlank(this.apiKey)) {
            return this.createApiKeyRestConnection(logger);
        }
        return this.createCredentialsRestConnection(logger);
    }

    public CredentialsRestConnection createCredentialsRestConnection(IntLogger logger) throws EncryptionException {
        CredentialsRestConnectionBuilder builder = new CredentialsRestConnectionBuilder();
        builder.setLogger(logger);
        builder.setBaseUrl(this.getHubUrl().toString());
        builder.setTimeout(this.getTimeout());
        builder.applyCredentials(this.getGlobalCredentials());
        builder.setAlwaysTrustServerCertificate(this.isAlwaysTrustServerCertificate());
        builder.applyProxyInfo(this.getProxyInfo());
        return (CredentialsRestConnection)builder.build();
    }

    public ApiKeyRestConnection createApiKeyRestConnection(IntLogger logger) {
        ApiKeyRestConnectionBuilder builder = new ApiKeyRestConnectionBuilder();
        builder.setLogger(logger);
        builder.setBaseUrl(this.getHubUrl().toString());
        builder.setTimeout(this.getTimeout());
        builder.setApiKey(this.getApiKey());
        builder.setAlwaysTrustServerCertificate(this.isAlwaysTrustServerCertificate());
        builder.applyProxyInfo(this.getProxyInfo());
        return (ApiKeyRestConnection)builder.build();
    }

    public URL getHubUrl() {
        return this.hubUrl;
    }

    public Credentials getGlobalCredentials() {
        return this.credentials;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public ProxyInfo getProxyInfo() {
        return this.proxyInfo;
    }

    public int getTimeout() {
        return this.timeoutSeconds;
    }

    public boolean isAlwaysTrustServerCertificate() {
        return this.alwaysTrustServerCertificate;
    }
}

