/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.dataservice.vulnerability;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.api.component.ComponentService;
import com.blackducksoftware.integration.hub.api.view.MetaHandler;
import com.blackducksoftware.integration.hub.api.vulnerability.VulnerabilityService;
import com.blackducksoftware.integration.hub.bdio.model.externalid.ExternalId;
import com.blackducksoftware.integration.hub.exception.HubIntegrationException;
import com.blackducksoftware.integration.hub.model.view.ComponentSearchResultView;
import com.blackducksoftware.integration.hub.model.view.ComponentVersionView;
import com.blackducksoftware.integration.hub.model.view.VulnerabilityView;
import com.blackducksoftware.integration.log.IntLogger;
import java.util.List;

public class VulnerabilityDataService {
    private final ComponentService componentService;
    private final VulnerabilityService vulnerabilityService;
    private final MetaHandler metaService;

    public VulnerabilityDataService(IntLogger logger, ComponentService componentRequestService, VulnerabilityService vulnerabilityRequestService) {
        this.componentService = componentRequestService;
        this.vulnerabilityService = vulnerabilityRequestService;
        this.metaService = new MetaHandler(logger);
    }

    public List<VulnerabilityView> getVulnerabilitiesFromComponentVersion(ExternalId externalId) throws IntegrationException {
        ComponentSearchResultView componentSearchView = this.componentService.getExactComponentMatch(externalId);
        String componentVersionURL = componentSearchView.componentVersionUrl;
        if (null != componentVersionURL) {
            ComponentVersionView componentVersion = this.componentService.getView(componentVersionURL, ComponentVersionView.class);
            String vulnerabilitiesLink = this.metaService.getFirstLink(componentVersion, "vulnerabilities");
            List<VulnerabilityView> vulnerabilityList = this.vulnerabilityService.getComponentVersionVulnerabilities(vulnerabilitiesLink);
            return vulnerabilityList;
        }
        throw new HubIntegrationException("Couldn't get a componentVersion url from the component matching " + externalId.createExternalId());
    }
}

