/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.dataservice.phonehome;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.api.nonpublic.HubRegistrationService;
import com.blackducksoftware.integration.hub.api.nonpublic.HubVersionService;
import com.blackducksoftware.integration.hub.dataservice.phonehome.PhoneHomeCallable;
import com.blackducksoftware.integration.hub.dataservice.phonehome.PhoneHomeResponse;
import com.blackducksoftware.integration.log.IntLogger;
import com.blackducksoftware.integration.phonehome.PhoneHomeClient;
import com.blackducksoftware.integration.phonehome.PhoneHomeRequestBody;
import com.blackducksoftware.integration.phonehome.PhoneHomeRequestBodyBuilder;
import com.blackducksoftware.integration.phonehome.enums.BlackDuckName;
import com.blackducksoftware.integration.phonehome.enums.PhoneHomeSource;
import com.blackducksoftware.integration.phonehome.enums.ThirdPartyName;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;

public class PhoneHomeDataService {
    private final IntLogger logger;
    private final HubRegistrationService hubRegistrationRequestService;
    private final HubVersionService hubVersionRequestService;
    private final PhoneHomeClient phoneHomeClient;
    private final ExecutorService executorService;

    public PhoneHomeDataService(IntLogger logger, PhoneHomeClient phoneHomeClient, HubRegistrationService hubRegistrationRequestService, HubVersionService hubVersionRequestService) {
        this.logger = logger;
        this.hubRegistrationRequestService = hubRegistrationRequestService;
        this.hubVersionRequestService = hubVersionRequestService;
        this.phoneHomeClient = phoneHomeClient;
        ThreadFactory threadFactory = Executors.defaultThreadFactory();
        this.executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), threadFactory);
    }

    public void phoneHome(ThirdPartyName thirdPartyName, String thirdPartyVersion, String pluginVersion) {
        this.phoneHome(thirdPartyName.getName(), thirdPartyVersion, pluginVersion);
    }

    public void phoneHome(String thirdPartyName, String thirdPartyVersion, String pluginVersion) {
        PhoneHomeRequestBodyBuilder phoneHomeRequestBodyBuilder = this.createInitialPhoneHomeRequestBodyBuilder(thirdPartyName, thirdPartyVersion, pluginVersion);
        this.phoneHome(phoneHomeRequestBodyBuilder);
    }

    public void phoneHome(PhoneHomeRequestBodyBuilder phoneHomeRequestBodyBuilder) {
        try {
            PhoneHomeRequestBody phoneHomeRequestBody = (PhoneHomeRequestBody)phoneHomeRequestBodyBuilder.build();
            this.phoneHome(phoneHomeRequestBody);
        }
        catch (Exception e) {
            this.logger.debug("Could not build phone home body" + e.getMessage());
        }
    }

    public void phoneHome(PhoneHomeRequestBody phoneHomeRequestBody) {
        if (phoneHomeRequestBody == PhoneHomeRequestBody.DO_NOT_PHONE_HOME) {
            this.logger.debug("Skipping phone-home");
        } else {
            try {
                this.phoneHomeClient.postPhoneHomeRequest(phoneHomeRequestBody);
            }
            catch (Exception e) {
                this.logger.debug("Problem with phone-home : " + e.getMessage(), e);
            }
        }
    }

    public PhoneHomeRequestBodyBuilder createInitialPhoneHomeRequestBodyBuilder(ThirdPartyName thirdPartyName, String thirdPartyVersion, String pluginVersion) {
        return this.createInitialPhoneHomeRequestBodyBuilder(thirdPartyName.getName(), thirdPartyVersion, pluginVersion);
    }

    public PhoneHomeRequestBodyBuilder createInitialPhoneHomeRequestBodyBuilder(String thirdPartyName, String thirdPartyVersion, String pluginVersion) {
        PhoneHomeRequestBodyBuilder phoneHomeRequestBodyBuilder = this.createInitialPhoneHomeRequestBodyBuilder();
        phoneHomeRequestBodyBuilder.setThirdPartyName(thirdPartyName);
        phoneHomeRequestBodyBuilder.setThirdPartyVersion(thirdPartyVersion);
        phoneHomeRequestBodyBuilder.setPluginVersion(pluginVersion);
        return phoneHomeRequestBodyBuilder;
    }

    public PhoneHomeRequestBodyBuilder createInitialPhoneHomeRequestBodyBuilder() {
        PhoneHomeRequestBodyBuilder phoneHomeRequestBodyBuilder = new PhoneHomeRequestBodyBuilder();
        try {
            String hubVersion = this.hubVersionRequestService.getHubVersion();
            String registrationId = null;
            try {
                registrationId = this.hubRegistrationRequestService.getRegistrationId();
            }
            catch (IntegrationException integrationException) {
                // empty catch block
            }
            URL hubHostName = this.hubRegistrationRequestService.getHubBaseUrl();
            phoneHomeRequestBodyBuilder.setRegistrationId(registrationId);
            phoneHomeRequestBodyBuilder.setHostName(hubHostName.toString());
            phoneHomeRequestBodyBuilder.setBlackDuckName(BlackDuckName.HUB);
            phoneHomeRequestBodyBuilder.setBlackDuckVersion(hubVersion);
            phoneHomeRequestBodyBuilder.setSource(PhoneHomeSource.INTEGRATIONS);
        }
        catch (Exception e) {
            this.logger.debug("Couldn't detail phone home request builder: " + e.getMessage());
        }
        return phoneHomeRequestBodyBuilder;
    }

    public PhoneHomeResponse startPhoneHome(ThirdPartyName thirdPartyName, String thirdPartyVersion, String pluginVersion) {
        return this.startPhoneHome(thirdPartyName.getName(), thirdPartyVersion, pluginVersion);
    }

    public PhoneHomeResponse startPhoneHome(String thirdPartyName, String thirdPartyVersion, String pluginVersion) {
        PhoneHomeRequestBodyBuilder phoneHomeRequestBodyBuilder = this.createInitialPhoneHomeRequestBodyBuilder(thirdPartyName, thirdPartyVersion, pluginVersion);
        return this.startPhoneHome(phoneHomeRequestBodyBuilder);
    }

    public PhoneHomeResponse startPhoneHome(PhoneHomeRequestBodyBuilder phoneHomeRequestBodyBuilder) {
        try {
            PhoneHomeRequestBody phoneHomeRequestBody = (PhoneHomeRequestBody)phoneHomeRequestBodyBuilder.build();
            return this.startPhoneHome(phoneHomeRequestBody);
        }
        catch (Exception e) {
            this.logger.debug("Could not build phone home body" + e.getMessage(), e);
            return null;
        }
    }

    public PhoneHomeResponse startPhoneHome(PhoneHomeRequestBody phoneHomeRequestBody) {
        PhoneHomeCallable task = new PhoneHomeCallable(this.logger, this.phoneHomeClient, phoneHomeRequestBody);
        Future<Boolean> resultTask = this.executorService.submit(task);
        return new PhoneHomeResponse(resultTask);
    }
}

