/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.dataservice.notification.transformer;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.api.notification.NotificationService;
import com.blackducksoftware.integration.hub.api.policy.PolicyService;
import com.blackducksoftware.integration.hub.api.project.version.ProjectVersionService;
import com.blackducksoftware.integration.hub.api.view.MetaHandler;
import com.blackducksoftware.integration.hub.dataservice.model.ProjectVersionModel;
import com.blackducksoftware.integration.hub.dataservice.notification.model.NotificationContentItem;
import com.blackducksoftware.integration.hub.dataservice.notification.model.PolicyNotificationFilter;
import com.blackducksoftware.integration.hub.dataservice.notification.transformer.AbstractNotificationTransformer;
import com.blackducksoftware.integration.hub.exception.HubItemTransformException;
import com.blackducksoftware.integration.hub.model.view.BomComponentPolicyStatusView;
import com.blackducksoftware.integration.hub.model.view.ComponentVersionView;
import com.blackducksoftware.integration.hub.model.view.NotificationView;
import com.blackducksoftware.integration.hub.model.view.PolicyRuleView;
import com.blackducksoftware.integration.hub.model.view.ProjectVersionView;
import com.blackducksoftware.integration.hub.model.view.components.ComponentVersionStatus;
import com.blackducksoftware.integration.hub.service.HubService;
import com.blackducksoftware.integration.log.IntLogger;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractPolicyTransformer
extends AbstractNotificationTransformer {
    private final PolicyNotificationFilter policyFilter;

    public AbstractPolicyTransformer(HubService hubResponseService, NotificationService notificationService, ProjectVersionService projectVersionService, PolicyService policyService, PolicyNotificationFilter policyFilter, MetaHandler metaService) {
        super(hubResponseService, notificationService, projectVersionService, policyService, metaService);
        this.policyFilter = policyFilter;
    }

    public AbstractPolicyTransformer(HubService hubResponseService, IntLogger logger, NotificationService notificationService, ProjectVersionService projectVersionService, PolicyService policyService, PolicyNotificationFilter policyFilter, MetaHandler metaService) {
        super(hubResponseService, logger, notificationService, projectVersionService, policyService, metaService);
        this.policyFilter = policyFilter;
    }

    public abstract void handleNotification(List<ComponentVersionStatus> var1, String var2, ProjectVersionView var3, NotificationView var4, List<NotificationContentItem> var5) throws HubItemTransformException;

    protected List<PolicyRuleView> getRulesFromUrls(List<String> ruleUrlsViolated) throws IntegrationException {
        if (ruleUrlsViolated == null || ruleUrlsViolated.isEmpty()) {
            return null;
        }
        ArrayList<PolicyRuleView> rules = new ArrayList<PolicyRuleView>();
        for (String ruleUrlViolated : ruleUrlsViolated) {
            PolicyRuleView ruleViolated = this.getPolicyService().getView(ruleUrlViolated, PolicyRuleView.class);
            rules.add(ruleViolated);
        }
        return rules;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<PolicyRuleView> getMatchingRules(List<PolicyRuleView> rulesViolated) throws IntegrationException {
        ArrayList<PolicyRuleView> filteredRules = new ArrayList<PolicyRuleView>();
        if (this.policyFilter == null || this.policyFilter.getRuleLinksToInclude() == null) return rulesViolated;
        if (rulesViolated == null) return rulesViolated;
        for (PolicyRuleView ruleViolated : rulesViolated) {
            String ruleHref = this.getMetaService().getHref(ruleViolated);
            if (!this.policyFilter.getRuleLinksToInclude().contains(ruleHref)) continue;
            filteredRules.add(ruleViolated);
        }
        return filteredRules;
    }

    protected PolicyNotificationFilter getPolicyFilter() {
        return this.policyFilter;
    }

    protected PolicyRuleView getPolicyRule(String ruleUrl) throws IntegrationException {
        PolicyRuleView rule = this.getPolicyService().getView(ruleUrl, PolicyRuleView.class);
        return rule;
    }

    protected List<String> getMatchingRuleUrls(List<String> rulesViolated) {
        ArrayList<String> filteredRules = new ArrayList<String>();
        if (this.policyFilter != null && this.policyFilter.getRuleLinksToInclude() != null) {
            for (String ruleViolated : rulesViolated) {
                if (!this.policyFilter.getRuleLinksToInclude().contains(ruleViolated)) continue;
                filteredRules.add(ruleViolated);
            }
        } else {
            return rulesViolated;
        }
        return filteredRules;
    }

    protected List<String> getRuleUrls(List<String> rulesViolated) {
        if (rulesViolated == null || rulesViolated.isEmpty()) {
            return null;
        }
        ArrayList<String> matchingRules = new ArrayList<String>();
        for (String ruleViolated : rulesViolated) {
            String fixedRuleUrl = this.fixRuleUrl(ruleViolated);
            matchingRules.add(fixedRuleUrl);
        }
        return matchingRules;
    }

    protected String fixRuleUrl(String origRuleUrl) {
        String fixedRuleUrl = origRuleUrl;
        if (origRuleUrl.contains("/internal/")) {
            fixedRuleUrl = origRuleUrl.replace("/internal/", "/");
        }
        return fixedRuleUrl;
    }

    protected BomComponentPolicyStatusView getBomComponentVersionPolicyStatus(String policyStatusUrl) throws IntegrationException {
        BomComponentPolicyStatusView bomComponentVersionPolicyStatus = this.getHubResponseService().getView(policyStatusUrl, BomComponentPolicyStatusView.class);
        return bomComponentVersionPolicyStatus;
    }

    public abstract void createContents(ProjectVersionModel var1, String var2, ComponentVersionView var3, String var4, String var5, List<PolicyRuleView> var6, NotificationView var7, List<NotificationContentItem> var8, String var9) throws URISyntaxException;
}

