/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.dataservice.license;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.api.component.ComponentService;
import com.blackducksoftware.integration.hub.api.license.LicenseService;
import com.blackducksoftware.integration.hub.bdio.model.externalid.ExternalId;
import com.blackducksoftware.integration.hub.model.view.ComplexLicenseView;
import com.blackducksoftware.integration.hub.model.view.ComponentSearchResultView;
import com.blackducksoftware.integration.hub.model.view.ComponentVersionView;
import com.blackducksoftware.integration.hub.model.view.LicenseView;
import com.blackducksoftware.integration.hub.model.view.components.VersionBomLicenseView;

public class LicenseDataService {
    private final ComponentService componentService;
    private final LicenseService licenseService;

    public LicenseDataService(ComponentService componentService, LicenseService licenseService) {
        this.componentService = componentService;
        this.licenseService = licenseService;
    }

    public ComplexLicenseView getComplexLicenseItemFromComponent(ExternalId externalId) throws IntegrationException {
        ComponentSearchResultView componentSearchView = this.componentService.getExactComponentMatch(externalId);
        String componentVersionUrl = componentSearchView.componentVersionUrl;
        ComponentVersionView componentVersion = this.componentService.getView(componentVersionUrl, ComponentVersionView.class);
        return componentVersion.license;
    }

    public LicenseView getLicenseView(VersionBomLicenseView versionBomLicenseView) throws IntegrationException {
        return this.getLicenseView(versionBomLicenseView.license);
    }

    public LicenseView getLicenseView(ComplexLicenseView complexLicenseView) throws IntegrationException {
        return this.getLicenseView(complexLicenseView.license);
    }

    public LicenseView getLicenseView(String licenseUrl) throws IntegrationException {
        if (licenseUrl == null) {
            return null;
        }
        LicenseView licenseView = this.licenseService.getView(licenseUrl, LicenseView.class);
        return licenseView;
    }

    public String getLicenseText(LicenseView licenseView) throws IntegrationException {
        return this.licenseService.getLicenseText(licenseView);
    }
}

