/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.api.project;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.exception.DoesNotExistException;
import com.blackducksoftware.integration.hub.model.request.ProjectRequest;
import com.blackducksoftware.integration.hub.model.view.ProjectView;
import com.blackducksoftware.integration.hub.request.HubPagedRequest;
import com.blackducksoftware.integration.hub.request.HubRequest;
import com.blackducksoftware.integration.hub.rest.RestConnection;
import com.blackducksoftware.integration.hub.service.HubService;
import java.util.Arrays;
import java.util.List;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;

public class ProjectService
extends HubService {
    private static final List<String> PROJECTS_SEGMENTS = Arrays.asList("api", "projects");

    public ProjectService(RestConnection restConnection) {
        super(restConnection);
    }

    public List<ProjectView> getAllProjects() throws IntegrationException {
        List<ProjectView> allProjectItems = this.getAllViewsFromApi("projects", ProjectView.class);
        return allProjectItems;
    }

    public List<ProjectView> getAllProjectMatches(String projectName) throws IntegrationException {
        HubPagedRequest hubPagedRequest = this.getHubRequestFactory().createPagedRequest(PROJECTS_SEGMENTS);
        if (StringUtils.isNotBlank(projectName)) {
            hubPagedRequest.q = "name:" + projectName;
        }
        List<ProjectView> allProjectItems = this.getAllViews(hubPagedRequest, ProjectView.class);
        return allProjectItems;
    }

    public List<ProjectView> getProjectMatches(String projectName, int limit) throws IntegrationException {
        HubPagedRequest hubPagedRequest = this.getHubRequestFactory().createPagedRequest(limit, PROJECTS_SEGMENTS);
        if (StringUtils.isNotBlank(projectName)) {
            hubPagedRequest.q = "name:" + projectName;
        }
        List<ProjectView> projectItems = this.getViews(hubPagedRequest, ProjectView.class);
        return projectItems;
    }

    public ProjectView getProjectByName(String projectName) throws IntegrationException {
        List<ProjectView> allProjectItems = this.getAllProjectMatches(projectName);
        for (ProjectView project : allProjectItems) {
            if (!projectName.equalsIgnoreCase(project.name)) continue;
            return project;
        }
        throw new DoesNotExistException("This Project does not exist. Project : " + projectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createHubProject(ProjectRequest project) throws IntegrationException {
        HubRequest projectItemRequest = this.getHubRequestFactory().createRequest(PROJECTS_SEGMENTS);
        try (Response response = null;){
            String projectJson = this.getGson().toJson(project);
            response = projectItemRequest.executePost(projectJson);
            String string = response.header("location");
            return string;
        }
    }

    public void deleteHubProject(ProjectView project) throws IntegrationException {
        HubRequest deleteRequest = this.getHubRequestFactory().createRequest(this.getHref(project));
        deleteRequest.executeDelete();
    }
}

