/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.api.component;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.bdio.model.externalid.ExternalId;
import com.blackducksoftware.integration.hub.exception.HubIntegrationException;
import com.blackducksoftware.integration.hub.model.view.ComponentSearchResultView;
import com.blackducksoftware.integration.hub.request.HubPagedRequest;
import com.blackducksoftware.integration.hub.rest.RestConnection;
import com.blackducksoftware.integration.hub.service.HubService;
import java.util.Arrays;
import java.util.List;

public class ComponentService
extends HubService {
    private static final List<String> COMPONENT_SEGMENTS = Arrays.asList("api", "components");

    public ComponentService(RestConnection restConnection) {
        super(restConnection);
    }

    public ComponentSearchResultView getExactComponentMatch(ExternalId externalId) throws IntegrationException {
        List<ComponentSearchResultView> allComponents = this.getAllComponents(externalId);
        String hubOriginIdToMatch = externalId.createHubOriginId();
        for (ComponentSearchResultView componentItem : allComponents) {
            if (null == hubOriginIdToMatch || !hubOriginIdToMatch.equals(componentItem.originId)) continue;
            return componentItem;
        }
        throw new HubIntegrationException("Couldn't find an exact component that matches " + hubOriginIdToMatch);
    }

    public List<ComponentSearchResultView> getAllComponents(ExternalId externalId) throws IntegrationException {
        String forge = externalId.forge.getName();
        String hubOriginId = externalId.createHubOriginId();
        String componentQuery = String.format("id:%s|%s", forge, hubOriginId);
        HubPagedRequest hubPagedRequest = this.getHubRequestFactory().createPagedRequest(COMPONENT_SEGMENTS, componentQuery);
        List<ComponentSearchResultView> allComponents = this.getAllViews(hubPagedRequest, ComponentSearchResultView.class);
        return allComponents;
    }
}

