/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.api.bom;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.request.HubRequest;
import com.blackducksoftware.integration.hub.rest.RestConnection;
import com.blackducksoftware.integration.hub.service.HubService;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import okhttp3.Response;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class BomImportService
extends HubService {
    private static final List<String> BOM_IMPORT_SEGMENTS = Arrays.asList("api", "bom-import");

    public BomImportService(RestConnection restConnection) {
        super(restConnection);
    }

    public void importBomFile(File file) throws IntegrationException {
        this.importBomFile(file, "application/ld+json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importBomFile(File file, String mediaType) throws IntegrationException {
        Response response = null;
        try {
            String jsonPayload;
            HubRequest hubRequest = this.getHubRequestFactory().createRequest(BOM_IMPORT_SEGMENTS);
            try {
                jsonPayload = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new IntegrationException("Failed to import Bom file: " + file.getAbsolutePath() + " to the Hub with because parsing the file to json failed: " + e.getMessage(), e);
            }
            response = hubRequest.executePost(mediaType, jsonPayload);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(response);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)response);
    }
}

