from blackduck.task.helper.risk_profile import *
from blackduck.hub_services_helper import HubServicesHelper
import datetime

if not blackduckServer:
    raise Exception("Blackduck server ID must be provided")

hub_services_helper = HubServicesHelper(params=blackduckServer)
hub_services_factory = hub_services_helper.get_hub_services_factory()
risk_profile_view, _, version_view = hub_services_helper.get_risk_profile(projectName, versionName)

security_risk_profile = RiskProfile('Security Risk :',
                                    Risk(risk_profile_view.categories.vulnerability.highCount, securityRiskHighThreshold),
                                    Risk(risk_profile_view.categories.vulnerability.mediumCount, securityRiskMediumThreshold),
                                    Risk(risk_profile_view.categories.vulnerability.lowCount, securityRiskLowThreshold),
                                    Risk(risk_profile_view.categories.vulnerability.okCount, None))

license_risk_profile = RiskProfile('License Risk :',
                                   Risk(risk_profile_view.categories.license.highCount, licenseRiskHighThreshold),
                                   Risk(risk_profile_view.categories.license.mediumCount, licenseRiskMediumThreshold),
                                   Risk(risk_profile_view.categories.license.lowCount, licenseRiskLowThreshold),
                                   Risk(risk_profile_view.categories.license.okCount, None))

operational_risk_profile = RiskProfile('Operational Risk :',
                                       Risk(risk_profile_view.categories.operational.highCount, operationalRiskHighThreshold),
                                       Risk(risk_profile_view.categories.operational.mediumCount, operationalRiskMediumThreshold),
                                       Risk(risk_profile_view.categories.operational.lowCount, operationalRiskLowThreshold),
                                       Risk(risk_profile_view.categories.operational.okCount, None))

print "```Last Analysis Time: {}```\n\n\n".format(risk_profile_view.bomLastUpdatedAt)

print "|       |  High         |  Medium       |  Low | None |"
print "|-"
security_risk_profile.pretty_print()
license_risk_profile.pretty_print()
operational_risk_profile.pretty_print()

if not (security_risk_profile.validate() and license_risk_profile.validate() and operational_risk_profile.validate()):
    raise RuntimeError("Risks are not allowed")
