/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.validator;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.exception.HubIntegrationException;
import com.blackducksoftware.integration.hub.proxy.ProxyInfo;
import com.blackducksoftware.integration.hub.rest.UnauthenticatedRestConnection;
import com.blackducksoftware.integration.hub.rest.UnauthenticatedRestConnectionBuilder;
import com.blackducksoftware.integration.hub.rest.exception.IntegrationRestException;
import com.blackducksoftware.integration.log.LogLevel;
import com.blackducksoftware.integration.log.PrintStreamIntLogger;
import java.net.URL;
import java.util.ArrayList;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;

public class HubServerVerifier {
    private final URL hubURL;
    private final ProxyInfo hubProxyInfo;
    private final int timeoutSeconds;
    private final boolean alwaysTrustServerCertificate;

    public HubServerVerifier(URL hubURL, ProxyInfo hubProxyInfo, boolean alwaysTrustServerCertificate, int timeoutSeconds) {
        this.hubURL = hubURL;
        this.hubProxyInfo = hubProxyInfo;
        this.alwaysTrustServerCertificate = alwaysTrustServerCertificate;
        this.timeoutSeconds = timeoutSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyIsHubServer() throws IntegrationException {
        Response response;
        Request request;
        HttpUrl httpUrl;
        UnauthenticatedRestConnection restConnection;
        block15: {
            UnauthenticatedRestConnectionBuilder connectionBuilder = new UnauthenticatedRestConnectionBuilder();
            connectionBuilder.setLogger(new PrintStreamIntLogger(System.out, LogLevel.INFO));
            connectionBuilder.setBaseUrl(this.hubURL.toString());
            connectionBuilder.setTimeout(this.timeoutSeconds);
            connectionBuilder.setAlwaysTrustServerCertificate(this.alwaysTrustServerCertificate);
            if (this.hubProxyInfo != null) {
                connectionBuilder.applyProxyInfo(this.hubProxyInfo);
            }
            restConnection = (UnauthenticatedRestConnection)connectionBuilder.build();
            httpUrl = restConnection.createHttpUrl();
            request = restConnection.createGetRequest(httpUrl);
            response = null;
            try {
                response = restConnection.handleExecuteClientCall(request);
            }
            catch (IntegrationRestException e) {
                if (e.getHttpStatusCode() == 401 && e.getHttpStatusCode() == 403) {
                    break block15;
                }
                throw e;
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }
        ArrayList<String> urlSegments = new ArrayList<String>();
        urlSegments.add("download");
        urlSegments.add("scan.cli.zip");
        httpUrl = restConnection.createHttpUrl(urlSegments);
        request = restConnection.createGetRequest(httpUrl);
        try {
            response = restConnection.handleExecuteClientCall(request);
        }
        catch (IntegrationRestException e) {
            throw new HubIntegrationException("The Url does not appear to be a Hub server :" + httpUrl.uri().toString() + ", because: " + e.getHttpStatusCode() + " : " + e.getHttpStatusMessage(), e);
        }
        catch (IntegrationException e) {
            throw new HubIntegrationException("The Url does not appear to be a Hub server :" + httpUrl.uri().toString() + ", because: " + e.getMessage(), e);
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }
}

