/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.validator;

import com.blackducksoftware.integration.hub.CredentialsFieldEnum;
import com.blackducksoftware.integration.validator.AbstractValidator;
import com.blackducksoftware.integration.validator.ValidationResult;
import com.blackducksoftware.integration.validator.ValidationResultEnum;
import com.blackducksoftware.integration.validator.ValidationResults;
import org.apache.commons.lang3.StringUtils;

public class CredentialsValidator
extends AbstractValidator {
    private String username;
    private String password;

    @Override
    public ValidationResults assertValid() {
        ValidationResults result = new ValidationResults();
        this.validateCredentials(result);
        return result;
    }

    public void validateCredentials(ValidationResults result) {
        this.validateUsername(result);
        this.validatePassword(result);
    }

    public void validateUsername(ValidationResults result) {
        if (StringUtils.isBlank(this.username)) {
            result.addResult(CredentialsFieldEnum.USERNAME, new ValidationResult(ValidationResultEnum.ERROR, "No Hub Username was found."));
        }
    }

    public void validatePassword(ValidationResults result) {
        if (StringUtils.isBlank(this.password)) {
            result.addResult(CredentialsFieldEnum.PASSWORD, new ValidationResult(ValidationResultEnum.ERROR, "No Hub Password was found."));
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

