/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.validator;

import com.blackducksoftware.integration.hub.rest.RestConnectionFieldEnum;
import com.blackducksoftware.integration.hub.validator.ProxyInfoValidator;
import com.blackducksoftware.integration.log.IntLogger;
import com.blackducksoftware.integration.validator.AbstractValidator;
import com.blackducksoftware.integration.validator.ValidationResult;
import com.blackducksoftware.integration.validator.ValidationResultEnum;
import com.blackducksoftware.integration.validator.ValidationResults;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractRestConnectionValidator
extends AbstractValidator {
    public static final String ERROR_MSG_TIMEOUT_NOT_VALID = "The Timeout must be greater than 0.";
    public static final String ERROR_MSG_COMMON_HEADERS_NOT_VALID = "The common headers map cannot be null";
    public static final String ERROR_MSG_LOGGER_NOT_VALID = "This logger instance cannot be null";
    public static final String ERROR_MSG_URL_NOT_FOUND = "No Hub Url was found.";
    public static final String ERROR_MSG_URL_NOT_VALID_PREFIX = "This is not a valid URL : ";
    public static final String ERROR_MSG_URL_NOT_VALID = "The Hub Url is not a valid URL.";
    private String baseUrl;
    private int timeout = 120;
    private String proxyHost;
    private int proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String proxyIgnoreHosts;
    private IntLogger logger;
    private Map<String, String> commonRequestHeaders = new HashMap<String, String>();

    @Override
    public ValidationResults assertValid() {
        ValidationResults result = new ValidationResults();
        this.validateBaseUrl(result);
        this.validateLogger(result);
        this.validateCommonRequestHeaders(result);
        this.validateProxyInfo(result);
        this.validateAdditionalFields(result);
        return result;
    }

    public void validateBaseUrl(ValidationResults result) {
        if (this.baseUrl == null) {
            result.addResult(RestConnectionFieldEnum.URL, new ValidationResult(ValidationResultEnum.ERROR, ERROR_MSG_URL_NOT_FOUND));
            return;
        }
        URL hubURL = null;
        try {
            hubURL = new URL(this.baseUrl);
            hubURL.toURI();
        }
        catch (MalformedURLException | URISyntaxException e) {
            result.addResult(RestConnectionFieldEnum.URL, new ValidationResult(ValidationResultEnum.ERROR, ERROR_MSG_URL_NOT_VALID));
            return;
        }
    }

    public void validateTimeout(ValidationResults result) {
        if (this.timeout <= 0) {
            result.addResult(RestConnectionFieldEnum.TIMEOUT, new ValidationResult(ValidationResultEnum.ERROR, ERROR_MSG_TIMEOUT_NOT_VALID));
        }
    }

    public void validateLogger(ValidationResults result) {
        if (this.logger == null) {
            result.addResult(RestConnectionFieldEnum.LOGGER, new ValidationResult(ValidationResultEnum.ERROR, ERROR_MSG_LOGGER_NOT_VALID));
        }
    }

    public void validateCommonRequestHeaders(ValidationResults result) {
        if (this.commonRequestHeaders == null) {
            result.addResult(RestConnectionFieldEnum.COMMON_HEADERS, new ValidationResult(ValidationResultEnum.ERROR, ERROR_MSG_COMMON_HEADERS_NOT_VALID));
        }
    }

    public void validateProxyInfo(ValidationResults result) {
        ProxyInfoValidator validator = new ProxyInfoValidator();
        validator.setHost(this.proxyHost);
        validator.setPort(this.proxyPort);
        validator.setUsername(this.proxyUsername);
        validator.setPassword(this.proxyPassword);
        validator.setIgnoredProxyHosts(this.proxyIgnoreHosts);
        result.addAllResults(validator.assertValid().getResultMap());
    }

    public abstract void validateAdditionalFields(ValidationResults var1);

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getProxyIgnoreHosts() {
        return this.proxyIgnoreHosts;
    }

    public void setProxyIgnoreHosts(String proxyIgnoreHosts) {
        this.proxyIgnoreHosts = proxyIgnoreHosts;
    }

    public IntLogger getLogger() {
        return this.logger;
    }

    public void setLogger(IntLogger logger) {
        this.logger = logger;
    }

    public Map<String, String> getCommonRequestHeaders() {
        return this.commonRequestHeaders;
    }

    public void setCommonRequestHeaders(Map<String, String> commonRequestHeaders) {
        this.commonRequestHeaders = commonRequestHeaders;
    }
}

