/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.rest;

import com.blackducksoftware.integration.exception.IntegrationException;
import com.blackducksoftware.integration.hub.proxy.ProxyInfo;
import com.blackducksoftware.integration.hub.rest.RestConnection;
import com.blackducksoftware.integration.hub.rest.exception.IntegrationRestException;
import com.blackducksoftware.integration.log.IntLogger;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;

public class ApiKeyRestConnection
extends RestConnection {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private final String hubApiKey;

    public ApiKeyRestConnection(IntLogger logger, URL hubBaseUrl, String hubApiKey, int timeout, ProxyInfo proxyInfo) {
        super(logger, hubBaseUrl, timeout, proxyInfo);
        this.hubApiKey = hubApiKey;
    }

    @Override
    public void addBuilderAuthentication() throws IntegrationRestException {
    }

    @Override
    public void clientAuthenticate() throws IntegrationException {
        ArrayList<String> segments = new ArrayList<String>();
        segments.add("api");
        segments.add("tokens");
        segments.add("authenticate");
        HttpUrl httpUrl = this.createHttpUrl(segments, null);
        HashMap<String, String> content = new HashMap<String, String>();
        if (StringUtils.isNotBlank(this.hubApiKey)) {
            Request request = this.createPostRequest(httpUrl, this.getRequestHeaders(), this.createEncodedFormBody(content));
            try (Response response = this.getClient().newCall(request).execute();){
                this.logResponseHeaders(response);
                if (!response.isSuccessful()) {
                    throw new IntegrationRestException(response.code(), response.message(), String.format("Connection Error: %s %s", response.code(), response.message()));
                }
                this.commonRequestHeaders.put(AUTHORIZATION_HEADER, "Bearer " + this.readBearerToken(response));
                String csrfToken = response.header("X-CSRF-TOKEN");
                if (StringUtils.isNotBlank(csrfToken)) {
                    this.commonRequestHeaders.put("X-CSRF-TOKEN", csrfToken);
                }
            }
            catch (IOException e) {
                throw new IntegrationException(e.getMessage(), e);
            }
        }
    }

    private Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(AUTHORIZATION_HEADER, "token " + this.hubApiKey);
        return headers;
    }

    private String readBearerToken(Response response) throws IOException {
        JsonParser jsonParser = new JsonParser();
        JsonObject bearerResponse = jsonParser.parse(response.body().string()).getAsJsonObject();
        return bearerResponse.get("bearerToken").getAsString();
    }
}

