/*
 * Decompiled with CFR 0.152.
 */
package com.blackducksoftware.integration.hub.proxy;

import com.blackducksoftware.integration.exception.EncryptionException;
import com.blackducksoftware.integration.hub.Credentials;
import com.blackducksoftware.integration.util.proxy.ProxyUtil;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.RecursiveToStringStyle;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;

public class ProxyInfo
implements Serializable {
    private static final long serialVersionUID = -7476704373593358472L;
    public static final ProxyInfo NO_PROXY_INFO = new NoProxyInfo();
    private final String host;
    private final int port;
    private final Credentials proxyCredentials;
    private final String ignoredProxyHosts;

    public ProxyInfo(String host, int port, Credentials proxyCredentials, String ignoredProxyHosts) {
        this.host = host;
        this.port = port;
        this.proxyCredentials = proxyCredentials;
        this.ignoredProxyHosts = ignoredProxyHosts;
    }

    public URLConnection openConnection(URL url) throws IOException {
        Proxy proxy = this.getProxy(url);
        return url.openConnection(proxy);
    }

    public Proxy getProxy(URL url) {
        if (this.shouldUseProxyForUrl(url)) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.host, this.port));
            return proxy;
        }
        return Proxy.NO_PROXY;
    }

    public boolean shouldUseProxyForUrl(URL url) {
        if (NO_PROXY_INFO.equals(this)) {
            return false;
        }
        if (StringUtils.isBlank(this.host) || this.port <= 0) {
            return false;
        }
        List<Pattern> ignoredProxyHostPatterns = ProxyUtil.getIgnoredProxyHostPatterns(this.ignoredProxyHosts);
        return !ProxyUtil.shouldIgnoreHost(url.getHost(), ignoredProxyHostPatterns);
    }

    public String toString() {
        return ReflectionToStringBuilder.toString(this, RecursiveToStringStyle.JSON_STYLE);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, new String[0]);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, obj, new String[0]);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        if (this.getProxyCredentials() == null) {
            return null;
        }
        return this.getProxyCredentials().getUsername();
    }

    public String getEncryptedPassword() {
        if (this.getProxyCredentials() == null) {
            return null;
        }
        return this.getProxyCredentials().getEncryptedPassword();
    }

    public String getDecryptedPassword() throws IllegalArgumentException, EncryptionException {
        if (this.getProxyCredentials() == null) {
            return null;
        }
        return this.getProxyCredentials().getDecryptedPassword();
    }

    public String getMaskedPassword() {
        if (this.getProxyCredentials() == null) {
            return null;
        }
        return this.getProxyCredentials().getMaskedPassword();
    }

    public int getActualPasswordLength() {
        if (this.getProxyCredentials() == null) {
            return 0;
        }
        return this.getProxyCredentials().getActualPasswordLength();
    }

    public String getIgnoredProxyHosts() {
        return this.ignoredProxyHosts;
    }

    private Credentials getProxyCredentials() {
        return this.proxyCredentials;
    }

    private static final class NoProxyInfo
    extends ProxyInfo {
        private static final long serialVersionUID = 7646573390510702513L;

        public NoProxyInfo() {
            super("", 0, null, "");
        }
    }
}

